/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.imaging;

import com.github.hypfvieh.imaging.AbstractImgHash;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImgAHash
extends AbstractImgHash {
    private static final ImgAHash INSTANCE = new ImgAHash();

    private ImgAHash() {
    }

    public static String computeHash(File _image) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(_image);
        BufferedImage resizedImage = INSTANCE.resizeAndGrayScale(8, 8, bufferedImage);
        int[] d = INSTANCE.createPixelArray(resizedImage);
        String s = INSTANCE.hash(d);
        return s;
    }

    private double calcMean(int[] _pixelArray) {
        double sum = 0.0;
        for (int i = 0; i < _pixelArray.length; ++i) {
            sum += (double)_pixelArray[i];
        }
        return sum / (double)_pixelArray.length;
    }

    private String hash(int[] _pixelArray) {
        boolean[] bitMask = new boolean[_pixelArray.length - 1];
        double mean = this.calcMean(_pixelArray);
        for (int i = 0; i < _pixelArray.length - 1; ++i) {
            if (!((double)_pixelArray[i] > mean)) continue;
            bitMask[i] = true;
        }
        return this.bitmaskToHex(bitMask, 16);
    }
}

