/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public final class SysoutToSystemLogger {
    private static final System.Logger LOGGER = System.getLogger(SysoutToSystemLogger.class.getName());
    private static PrintStream oldStdOut;
    private static PrintStream oldStdErr;

    private SysoutToSystemLogger() {
    }

    public static void enableRedirectSysout(System.Logger.Level _sysoutLogLevel, System.Logger.Level _sysErrLogLevel) {
        if (_sysoutLogLevel != null && !(System.out instanceof SystemLoggerPrintStream)) {
            oldStdOut = System.out;
            LOGGER.log(System.Logger.Level.INFO, "Enabling sysout redirection");
            System.setOut(new SystemLoggerPrintStream(_sysoutLogLevel, new NullOutputStream()));
        }
        if (_sysErrLogLevel != null && !(System.err instanceof SystemLoggerPrintStream)) {
            oldStdErr = System.err;
            LOGGER.log(System.Logger.Level.INFO, "Enabling syserr redirection");
            System.setErr(new SystemLoggerPrintStream(_sysErrLogLevel, new NullOutputStream()));
        }
    }

    public static void disableRedirectSysout() {
        if (System.out instanceof SystemLoggerPrintStream) {
            LOGGER.log(System.Logger.Level.INFO, "Disabling sysout redirection");
            System.out.close();
            System.setOut(oldStdOut);
            oldStdOut = null;
        }
        if (System.err instanceof SystemLoggerPrintStream) {
            LOGGER.log(System.Logger.Level.INFO, "Disabling sysout redirection");
            System.err.close();
            System.setErr(oldStdErr);
            oldStdErr = null;
        }
    }

    static class SystemLoggerPrintStream
    extends PrintStream {
        private final System.Logger.Level logLevel;

        SystemLoggerPrintStream(System.Logger.Level _loglevel, OutputStream _org) {
            super(_org);
            this.logLevel = _loglevel;
        }

        @Override
        public void println(String _x) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StackTraceElement caller = stack[2];
            System.getLogger(caller.getClassName()).log(this.logLevel, _x);
        }

        @Override
        public void print(String _s) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StackTraceElement caller = stack[2];
            System.getLogger(caller.getClassName()).log(this.logLevel, _s);
        }

        @Override
        public void print(boolean _b) {
            this.print(String.valueOf(_b));
        }

        @Override
        public void print(char _c) {
            this.print(String.valueOf(_c));
        }

        @Override
        public void print(int _i) {
            this.print(String.valueOf(_i));
        }

        @Override
        public void print(long _l) {
            this.print(String.valueOf(_l));
        }

        @Override
        public void print(float _f) {
            this.print(String.valueOf(_f));
        }

        @Override
        public void print(double _d) {
            this.print(String.valueOf(_d));
        }

        @Override
        public void print(char[] _s) {
            this.print(String.valueOf(_s));
        }

        @Override
        public void print(Object _obj) {
            this.print(String.valueOf(_obj));
        }

        @Override
        public void println() {
            this.println("");
        }

        @Override
        public void println(boolean _x) {
            this.println(String.valueOf(_x));
        }

        @Override
        public void println(char _x) {
            this.println(String.valueOf(_x));
        }

        @Override
        public void println(int _x) {
            this.println(String.valueOf(_x));
        }

        @Override
        public void println(long _x) {
            this.println(String.valueOf(_x));
        }

        @Override
        public void println(float _x) {
            this.println(String.valueOf(_x));
        }

        @Override
        public void println(double _x) {
            this.println(String.valueOf(_x));
        }

        @Override
        public void println(char[] _x) {
            this.println(String.valueOf(_x));
        }

        @Override
        public void println(Object _x) {
            this.println(String.valueOf(_x));
        }
    }

    static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        @Override
        public void write(byte[] _b, int _off, int _len) {
        }

        @Override
        public void write(int _b) {
        }

        @Override
        public void write(byte[] _b) throws IOException {
        }
    }
}

