/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.util.TypeUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public final class ConverterUtil {
    private ConverterUtil() {
    }

    public static Integer strToInt(String _str, Integer _default) {
        if (_str == null) {
            return _default;
        }
        if (TypeUtil.isInteger(_str, true)) {
            return Integer.valueOf(_str);
        }
        return _default;
    }

    public static Integer strToInt(String _str) {
        return ConverterUtil.strToInt(_str, null);
    }

    public static boolean strToBool(String _str) {
        return _str != null && _str.matches("(?i)^(1|y|j|ja|yes|true|enabled|enable|active)$");
    }

    public static Properties toProperties(Map<?, ?> _map) {
        Properties props = new Properties();
        props.putAll(_map);
        return props;
    }

    public static LocalDateTime toLocalDateTime(Date _date) {
        if (_date == null) {
            return null;
        }
        return _date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDate toLocalDate(Date _date) {
        if (_date == null) {
            return null;
        }
        return _date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalTime toLocalTime(Date _date) {
        if (_date == null) {
            return null;
        }
        return _date.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
    }
}

