/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.util.StringUtil;
import com.github.hypfvieh.util.TypeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FixUtil {
    public static final String FIX_DELIM = "\u0001";
    static final List<Integer> stdHeader = Arrays.asList(8, 9, 35, 49, 56, 115, 128, 90, 91, 34, 50, 142, 57, 143, 116, 144, 129, 145, 43, 97, 52, 122, 212, 213, 347, 369);
    static final List<Integer> stdHeaderHops = Arrays.asList(627, 628, 629, 630);
    static final List<Integer> stdTrailer = Arrays.asList(93, 98, 10);

    private FixUtil() {
    }

    public static String getDelimiterFromFixMsgStr(String _line) {
        if (StringUtil.isBlank(_line)) {
            return null;
        }
        Matcher matcher = Pattern.compile(".*?\\d+=[A-Za-z0-9\\. ]+([^0-9]*?)\\d+=.*").matcher(_line);
        if (matcher.matches() && !matcher.group(1).isEmpty()) {
            return matcher.group(1);
        }
        matcher = Pattern.compile(".*?(.)9=.*").matcher(_line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return _line.substring(_line.length() - 1);
    }

    public static String getFixTagValueFromString(String _msg, char _delimiter, int _tag) {
        String[] messageParts;
        for (String part : messageParts = StringUtil.split(_msg, _delimiter)) {
            String[] tagOrVals = StringUtil.split(part, "=");
            if (tagOrVals.length != 2 || !TypeUtil.isInteger(tagOrVals[0]) || Integer.parseInt(tagOrVals[0]) != _tag) continue;
            return tagOrVals[1];
        }
        return null;
    }

    public static String getFixTagValueFromString(String _msg, int _tag) {
        String delimiter = FixUtil.getDelimiterFromFixMsgStr(_msg);
        return FixUtil.getFixTagValueFromString(_msg, delimiter.charAt(0), _tag);
    }

    public static String setFixTagOnMsgStr(String _msg, int _tag, String _value) {
        char delimiter = FixUtil.getDelimiterFromFixMsgStr(_msg).charAt(0);
        return FixUtil.setFixTagOnMsgStr(_msg, _tag, _value, delimiter);
    }

    public static String setFixTagOnMsgStr(String _msg, int _tag, String _value, char _delim) {
        ArrayList<String> msgKeyValues = new ArrayList<String>(Arrays.asList(StringUtil.split(_msg, _delim)));
        ArrayList<TagValue> header = new ArrayList<TagValue>();
        ArrayList<TagValue> body = new ArrayList<TagValue>();
        ArrayList<TagValue> trailer = new ArrayList<TagValue>();
        for (String keyVal : msgKeyValues) {
            String[] split = keyVal.split("=");
            if (split.length < 2 || split.length > 2 || !TypeUtil.isInteger(split[0], false)) continue;
            int tagNo = Integer.parseInt(split[0]);
            if (stdHeader.contains(tagNo)) {
                header.add(new TagValue(tagNo, split[1]));
                continue;
            }
            if (stdHeaderHops.contains(tagNo)) {
                header.add(new TagValue(tagNo, split[1]));
                continue;
            }
            if (stdTrailer.contains(tagNo)) {
                trailer.add(new TagValue(tagNo, split[1]));
                continue;
            }
            body.add(new TagValue(tagNo, split[1]));
        }
        if (stdHeader.contains(_tag) || stdHeaderHops.contains(_tag)) {
            FixUtil.addOrUpdateTag(_tag, _value, header);
        } else if (stdTrailer.contains(_tag)) {
            FixUtil.addOrUpdateTag(_tag, _value, trailer);
        } else {
            FixUtil.addOrUpdateTag(_tag, _value, body);
        }
        StringBuilder fixMsgStr = new StringBuilder();
        stdHeader.forEach(hdrTag -> header.forEach(tagVal -> {
            if (tagVal.tag == hdrTag) {
                fixMsgStr.append(hdrTag).append("=").append(tagVal.value).append(_delim);
            }
        }));
        stdHeaderHops.forEach(hdrTag -> header.forEach(tagVal -> {
            if (tagVal.tag == hdrTag) {
                fixMsgStr.append(hdrTag).append("=").append(tagVal.value).append(_delim);
            }
        }));
        body.forEach(tv -> fixMsgStr.append(tv.tag).append("=").append(tv.value).append(_delim));
        stdTrailer.forEach(tlrTag -> trailer.forEach(tagVal -> {
            if (tagVal.tag == tlrTag) {
                fixMsgStr.append(tlrTag).append("=").append(tagVal.value).append(_delim);
            }
        }));
        return fixMsgStr.toString();
    }

    private static void addOrUpdateTag(int _tag, String _val, List<TagValue> _list) {
        if (_list == null || StringUtil.isBlank(_val)) {
            return;
        }
        AtomicBoolean updated = new AtomicBoolean(false);
        _list.stream().filter(tv -> tv.tag == _tag).forEach(tv -> {
            tv.value = _val;
            updated.set(true);
        });
        if (!updated.get()) {
            _list.add(new TagValue(_tag, _val));
        }
    }

    public static int calculateFixBodyLength(String _msg) {
        String delimiter = FixUtil.getDelimiterFromFixMsgStr(_msg);
        return FixUtil.calculateFixBodyLength(_msg, delimiter.charAt(0));
    }

    public static int calculateFixBodyLength(String _msg, char _delimiter) {
        String modMsg = FixUtil.setFixTagOnMsgStr(_msg, 9, "0");
        List<String> msgKeyValues = Arrays.asList(StringUtil.split(modMsg, _delimiter));
        boolean catchNext = false;
        int msgLen = 0;
        for (String keyValueStrPair : msgKeyValues) {
            String[] split = keyValueStrPair.split("=");
            if (split.length < 2 || split.length > 2 || !TypeUtil.isInteger(split[0])) continue;
            if (split[0].equals("10")) {
                catchNext = false;
            }
            if (catchNext) {
                msgLen += keyValueStrPair.length() + 1;
            }
            if (!split[0].equals("9")) continue;
            catchNext = true;
        }
        return msgLen;
    }

    public static String updateFixBodyLength(String _msg) {
        int msgLen = FixUtil.calculateFixBodyLength(_msg);
        return FixUtil.setFixTagOnMsgStr(_msg, 9, String.valueOf(msgLen));
    }

    public static String calculateFixCheckSum(String _msg, char _delim) {
        if (StringUtil.isEmpty(_msg)) {
            return null;
        }
        int chkSum = 0;
        String msg = _msg.replaceAll("10=.+$", "").replace(_delim, FIX_DELIM.charAt(0));
        int i = 0;
        while (i < msg.length()) {
            chkSum += msg.charAt(i++);
        }
        return String.format("%03d", chkSum % 256);
    }

    public static String updateFixCheckSum(String _msg) {
        String fixMsg = _msg.replace(FixUtil.getDelimiterFromFixMsgStr(_msg), FIX_DELIM);
        String checksum = FixUtil.calculateFixCheckSum(fixMsg, FIX_DELIM.charAt(0));
        return FixUtil.setFixTagOnMsgStr(_msg, 10, checksum);
    }

    public static boolean looksLikeFixMsg(String _msg) {
        return _msg.matches("^8=.*10=\\d+.$");
    }

    private static class TagValue {
        private int tag;
        private String value;

        TagValue(int _tag, String _val) {
            this.tag = _tag;
            this.value = _val;
        }

        public String toString() {
            return "TagValue [tag=" + this.tag + ", value=" + this.value + "]";
        }
    }
}

