/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.util.FixUtil;
import java.lang.invoke.CallSite;
import java.lang.invoke.StringConcatFactory;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SimpleFixMessageBuilder {
    private final List<String> tagValues = new ArrayList<String>();

    public SimpleFixMessageBuilder setValue(int _tag, Object _value, boolean _overwrite) {
        if (_value == null || _value.toString().isEmpty()) {
            return this;
        }
        if (_value.toString().contains("\u0001")) {
            throw new IllegalArgumentException("FIX delimiter is illegal in tag value.");
        }
        String tagVal = String.format("%s=%s", _tag, _value);
        if (_overwrite) {
            this.tagValues.removeIf(tv -> _tag == Integer.parseInt(tv.substring(0, tv.indexOf("="))));
        }
        this.tagValues.add(tagVal);
        return this;
    }

    public SimpleFixMessageBuilder setValue(int _tag, Object _value) {
        return this.setValue(_tag, _value, true);
    }

    public SimpleFixMessageBuilder setUtcTimestamp(int _tag) {
        return this.setUtcTimestamp(_tag, ZonedDateTime.now(ZoneOffset.UTC));
    }

    public SimpleFixMessageBuilder setUtcTimestamp(int _tag, ZonedDateTime _zonedDateTime) {
        String ts = DateTimeFormatter.ofPattern("yyyyMMdd-HH:mm:ss.SSS").format(_zonedDateTime);
        return this.setValue(_tag, ts, true);
    }

    public SimpleFixMessageBuilder createBasicMessage(String _fixVersion, String _msgType) {
        Objects.requireNonNull(_fixVersion, "FIX version cannot be null");
        Objects.requireNonNull(_msgType, "Message type cannot be null");
        String fixVersion = _fixVersion;
        if (_fixVersion.contains("5.0")) {
            fixVersion = "FIXT.1.1";
        }
        this.setValue(8, fixVersion, true);
        this.setValue(9, "0", true);
        this.setValue(35, _msgType, true);
        this.setValue(49, "SENDER", true);
        this.setValue(56, "TARGET", true);
        this.setValue(34, "1", true);
        this.setUtcTimestamp(52);
        this.setValue(10, "0");
        return this;
    }

    public String build() {
        ArrayList<Object> orderedMsg = new ArrayList<Object>();
        for (Integer tagNum : FixUtil.stdHeader) {
            for (String string : this.tagValues) {
                int tag = Integer.parseInt(string.substring(0, string.indexOf("=")));
                if (tagNum != tag) continue;
                orderedMsg.add(string);
            }
        }
        Optional<String> hasHeaderHops = this.tagValues.stream().filter(tv -> Integer.parseInt(tv.substring(0, tv.indexOf("="))) == FixUtil.stdHeaderHops.get(0)).findFirst();
        if (hasHeaderHops.isPresent()) {
            ArrayList<Object> groupHops = new ArrayList<Object>();
            Object hop = null;
            for (String tagValue : this.tagValues) {
                int tagNum = Integer.parseInt(tagValue.substring(0, tagValue.indexOf("=")));
                if (!FixUtil.stdHeaderHops.contains(tagNum) || tagNum == FixUtil.stdHeaderHops.get(0)) continue;
                if (tagNum == FixUtil.stdHeaderHops.get(1)) {
                    hop = new ArrayList(FixUtil.stdHeaderHops.size() - 1);
                    groupHops.add(hop);
                    for (int j = 0; j < FixUtil.stdHeaderHops.size() - 1; ++j) {
                        hop.add(null);
                    }
                }
                if (hop == null) continue;
                int tagPosition = FixUtil.stdHeaderHops.indexOf(tagNum);
                hop.add(tagPosition, tagValue);
            }
            orderedMsg.add(hasHeaderHops.get());
            groupHops.stream().flatMap(Collection::stream).filter(Objects::nonNull).forEach(orderedMsg::add);
        }
        ArrayList<String> trailer = new ArrayList<String>();
        for (Integer n : FixUtil.stdTrailer) {
            for (String tagVal : this.tagValues) {
                int tag = Integer.parseInt(tagVal.substring(0, tagVal.indexOf("=")));
                if (n != tag) continue;
                trailer.add(tagVal);
            }
        }
        this.tagValues.stream().filter(tv -> {
            int tagNum = Integer.parseInt(tv.substring(0, tv.indexOf("=")));
            return !FixUtil.stdTrailer.contains(tagNum) && !FixUtil.stdHeader.contains(tagNum) && !FixUtil.stdHeaderHops.contains(tagNum);
        }).forEach(orderedMsg::add);
        orderedMsg.addAll(trailer);
        CallSite msg = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0001"}, (String)String.join((CharSequence)"\u0001", orderedMsg));
        int n = FixUtil.calculateFixBodyLength((String)((Object)msg));
        int bodyLenPos = FixUtil.stdHeader.indexOf(9);
        if (((String)orderedMsg.get(bodyLenPos)).startsWith("9=")) {
            orderedMsg.remove(bodyLenPos);
        }
        orderedMsg.add(bodyLenPos, "9=" + n);
        msg = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0001"}, (String)String.join((CharSequence)"\u0001", orderedMsg));
        String checkSum = FixUtil.calculateFixCheckSum((String)((Object)msg), '\u0001');
        if (((String)orderedMsg.get(orderedMsg.size() - 1)).startsWith("10=")) {
            orderedMsg.remove(orderedMsg.size() - 1);
        }
        orderedMsg.add("10=" + checkSum);
        msg = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0001"}, (String)String.join((CharSequence)"\u0001", orderedMsg));
        return msg;
    }
}

