/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.util.TypeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public final class StringUtil {
    private static final char[] SYMBOLS;

    private StringUtil() {
    }

    public static String abbreviate(String _str, int _length) {
        if (_str == null) {
            return null;
        }
        if (_str.length() <= _length) {
            return _str;
        }
        String abbr = _str.substring(0, _length - 3) + "...";
        return abbr;
    }

    public static List<String> smartWordSplit(String _text, int _len) {
        if (_text == null) {
            return null;
        }
        if (_text.length() <= _len) {
            return TypeUtil.createList(_text);
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] result = _text.split("\\s");
        for (int x = 0; x < result.length; ++x) {
            if (result[x].length() > _len) {
                list.addAll(StringUtil.splitEqually(result[x], _len));
                continue;
            }
            if (result[x].length() < _len) {
                StringBuilder sb = new StringBuilder();
                x = StringUtil.strAppender(result, sb, x, _len);
                list.add(sb.toString());
                continue;
            }
            list.add(result[x]);
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int strAppender(String[] _text, StringBuilder _sbResult, int _beginIdx, int _len) {
        if (_text == null) return -1;
        if (_sbResult == null) {
            return -1;
        }
        if (_beginIdx > _text.length) {
            return _text.length;
        }
        int i = _beginIdx;
        i = _beginIdx;
        while (i < _text.length) {
            if (_sbResult.length() >= _len) {
                if (i <= _beginIdx) return i;
                return --i;
            }
            int condition = _text[i].length() + _sbResult.length();
            boolean firstOrLastToken = true;
            if (i <= _text.length - 1 && _sbResult.length() > 0) {
                ++condition;
                firstOrLastToken = false;
            }
            if (condition > _len) {
                return --i;
            }
            if (!firstOrLastToken) {
                _sbResult.append(" ");
            }
            _sbResult.append(_text[i]);
            ++i;
        }
        return i;
    }

    public static List<String> splitEqually(String _text, int _len) {
        if (_text == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>((_text.length() + _len - 1) / _len);
        for (int start = 0; start < _text.length(); start += _len) {
            ret.add(_text.substring(start, Math.min(_text.length(), start + _len)));
        }
        return ret;
    }

    public static String replaceByMap(String _searchStr, Map<String, String> _replacements) {
        if (_searchStr == null) {
            return null;
        }
        if (_replacements == null || _replacements.isEmpty()) {
            return _searchStr;
        }
        String str = _searchStr;
        for (Map.Entry<String, String> entry : _replacements.entrySet()) {
            str = str.replace(entry.getKey(), entry.getValue());
        }
        return str;
    }

    public static String lowerCaseFirstChar(String _str) {
        if (_str == null) {
            return null;
        }
        if (_str.isEmpty()) {
            return _str;
        }
        return _str.substring(0, 1).toLowerCase() + _str.substring(1);
    }

    public static String upperCaseFirstChar(String _str) {
        if (_str == null) {
            return null;
        }
        if (_str.isEmpty()) {
            return _str;
        }
        return _str.substring(0, 1).toUpperCase() + _str.substring(1);
    }

    public static String rot13(String _input) {
        if (_input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < _input.length(); ++i) {
            char c = _input.charAt(i);
            if (c >= 'a' && c <= 'm') {
                c = (char)(c + 13);
            } else if (c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z') {
                c = (char)(c - 13);
            } else if (c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean equalsIgnoreCaseAny(String _str, String ... _compare) {
        return StringUtil.equalsAny(true, _str, _compare);
    }

    public static boolean equalsAny(String _str, String ... _compare) {
        return StringUtil.equalsAny(false, _str, _compare);
    }

    public static boolean equalsAny(boolean _ignoreCase, String _str, String ... _compare) {
        if (_str == null && _compare == null || _compare.length == 0) {
            return true;
        }
        if (_str == null) {
            return false;
        }
        for (String cmp : _compare) {
            if (!(_ignoreCase ? cmp.equalsIgnoreCase(_str) : cmp.equals(_str))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlank(CharSequence _str) {
        if (_str == null || _str.length() == 0) {
            return true;
        }
        return IntStream.range(0, _str.length()).allMatch(i -> Character.isWhitespace(_str.charAt(i)));
    }

    public static boolean isNotBlank(CharSequence _str) {
        return !StringUtil.isBlank(_str);
    }

    public static boolean isEmpty(CharSequence _str) {
        return _str == null || _str.length() == 0;
    }

    public static String defaultIfBlank(String _str, String _default) {
        return StringUtil.isBlank(_str) ? _default : _str;
    }

    public static String randomString(int _length) {
        if (_length <= 0) {
            return "";
        }
        Random random = new Random();
        char[] buf = new char[_length];
        for (int idx = 0; idx < buf.length; ++idx) {
            buf[idx] = SYMBOLS[random.nextInt(SYMBOLS.length)];
        }
        return new String(buf);
    }

    public static String trim(String _str) {
        return _str == null ? null : _str.trim();
    }

    public static String trimToNull(String _str) {
        String val = StringUtil.trim(_str);
        if (val == null || val.isEmpty()) {
            return null;
        }
        return val;
    }

    public static String trimToEmpty(String _str) {
        String val;
        String string = val = _str == null ? "" : StringUtil.trim(_str);
        if (val == null || val.isEmpty()) {
            return "";
        }
        return val;
    }

    public static String join(String _delimiter, List<String> _strings) {
        if (_strings == null) {
            return null;
        }
        if (_delimiter == null) {
            _delimiter = "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < _strings.size(); ++i) {
            sb.append(_strings.get(i));
            if (i >= _strings.size() - 1) continue;
            sb.append(_delimiter);
        }
        return sb.toString();
    }

    public static String join(String _delimiter, String[] _strings) {
        return StringUtil.join(_delimiter, Arrays.asList(_strings));
    }

    public static String convertCamelToUpperCase(String _str) {
        if (StringUtil.isEmpty(_str) || StringUtil.isAllUpperCase(_str)) {
            return _str;
        }
        StringBuffer sb = new StringBuffer(String.valueOf(_str.charAt(0)).toUpperCase());
        for (int i = 1; i < _str.length(); ++i) {
            char c = _str.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                sb.append('_');
            }
            sb.append(c);
        }
        return sb.toString().toUpperCase();
    }

    public static String convertUpperToCamelCase(String _str) {
        if (_str == null || StringUtil.isBlank(_str)) {
            return _str;
        }
        if (!_str.contains("_")) {
            return ("" + _str.charAt(0)).toUpperCase() + _str.substring(1);
        }
        StringBuffer sb = new StringBuffer(String.valueOf(_str.charAt(0)).toUpperCase());
        for (int i = 1; i < _str.length(); ++i) {
            char c = _str.charAt(i);
            c = c == '_' ? String.valueOf(_str.charAt(++i)).toUpperCase().charAt(0) : String.valueOf(c).toLowerCase().charAt(0);
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isAllUpperCase(String _str) {
        return StringUtil.isEmpty(_str) || !_str.matches(".*[a-z].*");
    }

    public static boolean containsAnyIgnoreCase(String _str, String ... _args) {
        return StringUtil.containsAny(true, _str, _args);
    }

    public static boolean containsAny(String _str, String ... _args) {
        return StringUtil.containsAny(false, _str, _args);
    }

    public static boolean containsAny(boolean _ignoreCase, String _str, String ... _args) {
        if (_str == null || _args == null || _args.length == 0) {
            return false;
        }
        String heystack = _str;
        if (_ignoreCase) {
            heystack = _str.toLowerCase();
        }
        for (String s : _args) {
            String needle;
            String string = needle = _ignoreCase ? s.toLowerCase() : s;
            if (!heystack.contains(needle)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithAny(boolean _ignoreCase, String _str, String ... _args) {
        if (_str == null || _args == null || _args.length == 0) {
            return false;
        }
        String heystack = _str;
        if (_ignoreCase) {
            heystack = _str.toLowerCase();
        }
        for (String s : _args) {
            String needle;
            String string = needle = _ignoreCase ? s.toLowerCase() : s;
            if (!heystack.endsWith(needle)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithAny(boolean _ignoreCase, String _str, String ... _args) {
        if (_str == null || _args == null || _args.length == 0) {
            return false;
        }
        String heystack = _str;
        if (_ignoreCase) {
            heystack = _str.toLowerCase();
        }
        for (String s : _args) {
            String needle;
            String string = needle = _ignoreCase ? s.toLowerCase() : s;
            if (!heystack.startsWith(needle)) continue;
            return true;
        }
        return false;
    }

    public static String repeat(String _str, int _count) {
        if (_str == null || _count <= 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < _count; ++i) {
            sb.append(_str);
        }
        return sb.toString();
    }

    public static String rightPad(String _str, int _size, String _padChar) {
        if (_str == null) {
            return null;
        }
        int pads = _size - _str.length();
        if (pads <= 0) {
            return _str;
        }
        return _str.concat(StringUtil.repeat(_padChar, pads));
    }

    public static String[] split(String _str, char _separatorChar) {
        return StringUtil.split(_str, Character.toString(_separatorChar));
    }

    public static String[] split(String _str, String _separatorStr) {
        if (_str == null) {
            return null;
        }
        List<String> list = StringUtil.splitToList(_str, _separatorStr);
        return list.toArray(new String[list.size()]);
    }

    public static String[] split(String _str) {
        return StringUtil.split(_str, ' ');
    }

    public static List<String> splitToList(String _str, char _separatorChar) {
        return StringUtil.splitToList(_str, Character.toString(_separatorChar));
    }

    public static List<String> splitToList(String _str, String _separatorStr) {
        if (_str == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(_str, _separatorStr);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    public static String mask(String _str, String _maskStr, int _maskBgn, int _maskRpt) {
        if (_str == null || _maskStr == null || _maskStr.isEmpty()) {
            return null;
        }
        if (_maskBgn < 0 || _maskRpt <= 0 || _maskRpt - _maskBgn < 0) {
            return _str;
        }
        if (_maskBgn > _str.length()) {
            return _str;
        }
        StringBuilder sb = new StringBuilder();
        int maskCnt = 0;
        for (int i = 0; i < _str.length(); ++i) {
            if (i < _maskBgn) {
                sb.append(_str.charAt(i));
                continue;
            }
            if (maskCnt < _maskRpt) {
                sb.append(_maskStr);
                ++maskCnt;
                continue;
            }
            sb.append(_str.charAt(i));
        }
        return sb.toString();
    }

    public static String snakeToCamelCase(String _input) {
        if (StringUtil.isBlank(_input)) {
            return _input;
        }
        Pattern compile = Pattern.compile("_[a-zA-Z]");
        Matcher matcher = compile.matcher(_input);
        String result = _input;
        while (matcher.find()) {
            String match = matcher.group();
            String replacement = match.replace("_", "");
            replacement = replacement.toUpperCase();
            result = result.replaceFirst(match, replacement);
        }
        return result;
    }

    public static String concatStrings(boolean _ignoreEmpty, String _separator, String ... _parts) {
        if (_parts == null) {
            return null;
        }
        StringBuilder allParts = new StringBuilder();
        for (int i = 0; i < _parts.length; ++i) {
            if (_parts[i] == null || _ignoreEmpty && _parts[i].isEmpty()) continue;
            allParts.append(_parts[i]);
            if (_parts[i].endsWith(_separator)) continue;
            allParts.append(_separator);
        }
        if (allParts.toString().isEmpty()) {
            return "";
        }
        return allParts.toString().substring(0, allParts.lastIndexOf(_separator));
    }

    public static <T extends CharSequence> T requireNonBlank(T _str, String _message) {
        if (StringUtil.isBlank(_str)) {
            throw new IllegalArgumentException(_message);
        }
        return _str;
    }

    public static <T extends CharSequence> T requireNonBlank(T _str) {
        return StringUtil.requireNonBlank(_str, "String may not be blank");
    }

    public static <T extends CharSequence> T requireNonEmpty(T _str, String _message) {
        if (StringUtil.isEmpty(_str)) {
            throw new IllegalArgumentException(_message);
        }
        return _str;
    }

    public static <T extends CharSequence> T requireNonEmpty(T _str) {
        return StringUtil.requireNonEmpty(_str, "String may not be empty");
    }

    public static int countSubString(String string, String substring) {
        int count = 0;
        int idx = 0;
        while ((idx = string.indexOf(substring, idx)) != -1) {
            ++idx;
            ++count;
        }
        return count;
    }

    public static String substringAfterLast(String _str, String _separator) {
        if (StringUtil.isEmpty(_str)) {
            return _str;
        }
        if (StringUtil.isEmpty(_separator)) {
            return "";
        }
        int pos = _str.lastIndexOf(_separator);
        if (pos == -1 || pos == _str.length() - _separator.length()) {
            return "";
        }
        return _str.substring(pos + _separator.length());
    }

    static {
        char ch;
        StringBuilder tmp = new StringBuilder();
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            tmp.append(ch);
        }
        for (ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
            tmp.append(ch);
        }
        for (ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            tmp.append(ch);
        }
        SYMBOLS = tmp.toString().toCharArray();
    }
}

