/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.column;

import com.github.jasync.sql.db.column.ColumnEncoderDecoder;
import com.github.jasync.sql.db.exceptions.DateEncoderNotAvailableException;
import com.github.jasync.sql.db.general.ColumnData;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/jasync/sql/db/column/TimestampEncoderDecoder;", "Lcom/github/jasync/sql/db/column/ColumnEncoderDecoder;", "()V", "builder", "Ljava/time/format/DateTimeFormatterBuilder;", "kotlin.jvm.PlatformType", "format", "Ljava/time/format/DateTimeFormatter;", "nonTimezonedPrinter", "optional", "optionalTimeZone", "timezonedPrinter", "decode", "", "value", "", "encode", "encodeLegacyDate", "legacyDate", "Ljava/util/Date;", "formatter", "Companion", "jasync-common"})
public class TimestampEncoderDecoder
implements ColumnEncoderDecoder {
    private final DateTimeFormatter optional = new DateTimeFormatterBuilder().appendPattern(".SSSSSS").toFormatter();
    private final DateTimeFormatter optionalTimeZone = new DateTimeFormatterBuilder().appendPattern("[X][Z]").toFormatter();
    private final DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendOptional(this.optional).appendOptional(this.optionalTimeZone);
    private final DateTimeFormatter timezonedPrinter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss.SSSSSSZ").toFormatter();
    private final DateTimeFormatter nonTimezonedPrinter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss.SSSSSS").toFormatter();
    private final DateTimeFormatter format = this.builder.toFormatter();
    @NotNull
    public static final String BaseFormat = "yyyy-MM-dd HH:mm:ss";
    @NotNull
    public static final String MillisFormat = ".SSSSSS";
    @NotNull
    private static final TimestampEncoderDecoder Instance;
    @NotNull
    public static final Companion Companion;

    private final String encodeLegacyDate(Date legacyDate) {
        String string = legacyDate.toInstant().atOffset(ZoneOffset.UTC).format(this.timezonedPrinter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"legacyDate.toInstant().a\u2026at(this.timezonedPrinter)");
        return string;
    }

    public DateTimeFormatter formatter() {
        return this.format;
    }

    @Override
    @NotNull
    public Object decode(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        LocalDateTime localDateTime = LocalDateTime.parse(value, this.formatter());
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"LocalDateTime.parse(value, formatter())");
        return localDateTime;
    }

    @Override
    @NotNull
    public String encode(@NotNull Object value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Timestamp) {
            string = this.encodeLegacyDate((Date)value);
        } else if (object instanceof Date) {
            string = this.encodeLegacyDate((Date)value);
        } else if (object instanceof Calendar) {
            Date date = ((Calendar)value).getTime();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"value.time");
            string = this.encodeLegacyDate(date);
        } else if (object instanceof LocalDateTime) {
            String string2 = this.nonTimezonedPrinter.format((TemporalAccessor)value);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.nonTimezonedPrinter.format(value)");
        } else if (object instanceof TemporalAccessor) {
            String string3 = this.timezonedPrinter.format((TemporalAccessor)value);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this.timezonedPrinter.format(value)");
        } else {
            throw (Throwable)new DateEncoderNotAvailableException(value);
        }
        return string;
    }

    static {
        Companion = new Companion(null);
        Instance = new TimestampEncoderDecoder();
    }

    @Override
    @Nullable
    public Object decode(@NotNull ColumnData kind, @NotNull ByteBuf value, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return ColumnEncoderDecoder.DefaultImpls.decode(this, kind, value, charset);
    }

    @Override
    public boolean supportsStringDecoding() {
        return ColumnEncoderDecoder.DefaultImpls.supportsStringDecoding(this);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/github/jasync/sql/db/column/TimestampEncoderDecoder$Companion;", "", "()V", "BaseFormat", "", "Instance", "Lcom/github/jasync/sql/db/column/TimestampEncoderDecoder;", "getInstance", "()Lcom/github/jasync/sql/db/column/TimestampEncoderDecoder;", "MillisFormat", "jasync-common"})
    public static final class Companion {
        @NotNull
        public final TimestampEncoderDecoder getInstance() {
            return Instance;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

