/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application.motor.grain;

import com.github.jbgust.jsrm.application.exception.InvalidMotorDesignException;
import com.github.jbgust.jsrm.application.motor.SolidRocketMotor;
import com.github.jbgust.jsrm.application.motor.grain.GrainSurface;
import com.github.jbgust.jsrm.application.motor.grain.core.BurningShape;
import com.github.jbgust.jsrm.application.motor.grain.core.ExtrudedShapeGrain;
import java.awt.geom.Ellipse2D;

public class MoonBurnerGrain
extends ExtrudedShapeGrain {
    private final double outerDiameter;
    private final double coreDiameter;
    private final double coreOffset;
    private final int numberOfSegment;

    public MoonBurnerGrain(double outerDiameter, double coreDiameter, double coreOffset, int numberOfSegment, double length, GrainSurface endSurface) {
        this.outerDiameter = outerDiameter;
        this.coreDiameter = coreDiameter;
        this.coreOffset = coreOffset;
        this.numberOfSegment = numberOfSegment;
        this.setAftEndInhibited(endSurface);
        this.setForeEndInhibited(endSurface);
        this.setLength(length);
        this.generateGeometry();
    }

    private void generateGeometry() {
        double odmm = this.outerDiameter;
        double idmm = this.coreDiameter;
        double offmm = this.coreOffset;
        this.xsection = new BurningShape();
        Ellipse2D.Double outside = new Ellipse2D.Double(0.0, 0.0, odmm, odmm);
        this.xsection.add(outside);
        this.xsection.inhibit(outside);
        this.xsection.subtract(new Ellipse2D.Double(odmm / 2.0 - idmm / 2.0 + offmm, odmm / 2.0 - idmm / 2.0, idmm, idmm));
    }

    @Override
    public int getNumberOfSegments() {
        return this.numberOfSegment;
    }

    @Override
    public void checkConfiguration(SolidRocketMotor solidRocketMotor) throws InvalidMotorDesignException {
        if (this.coreDiameter <= 0.0) {
            throw new InvalidMotorDesignException("Core diameter should be positive");
        }
        if (this.outerDiameter <= 0.0) {
            throw new InvalidMotorDesignException("Outer diameter should be > 0");
        }
        if (this.getLength() <= 0.0) {
            throw new InvalidMotorDesignException("Grain length should be > 0");
        }
        if (this.numberOfSegment <= 0) {
            throw new InvalidMotorDesignException("Number of segment should be > 0");
        }
        if (this.coreDiameter >= this.outerDiameter) {
            throw new InvalidMotorDesignException("Core diameter should be < than outer diameter");
        }
        if (this.getLength() * (double)this.getNumberOfSegments() > solidRocketMotor.getCombustionChamber().getChamberLengthInMillimeter()) {
            throw new InvalidMotorDesignException("Combustion chamber length should be >= than Grain total length");
        }
        if (this.outerDiameter > solidRocketMotor.getCombustionChamber().getChamberInnerDiameterInMillimeter()) {
            throw new InvalidMotorDesignException("Combution chamber diameter should be >= than grain outer diameter");
        }
        if (this.coreOffset < 0.0) {
            throw new InvalidMotorDesignException("Core offset should be positive");
        }
        if (this.coreOffset >= (this.coreDiameter + this.outerDiameter) / 2.0) {
            throw new InvalidMotorDesignException("Core offset should be inside the grain");
        }
    }
}

