/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application.motor.grain;

import com.github.jbgust.jsrm.application.exception.InvalidMotorDesignException;
import com.github.jbgust.jsrm.application.motor.SolidRocketMotor;
import com.github.jbgust.jsrm.application.motor.grain.GrainConfigutation;
import com.github.jbgust.jsrm.application.motor.grain.GrainSurface;
import com.github.jbgust.jsrm.infra.function.HollowCircleAreaFunction;

public class RodAndTubeGrain
implements GrainConfigutation {
    private final double rodDiameter;
    private final double tubeOuterDiameter;
    private final double tubeInnerDiameter;
    private final int numberOfSegment;
    private final double length;
    private final GrainSurface endSurface;

    public RodAndTubeGrain(double rodDiameter, double tubeOuterDiameter, double tubeInnerDiameter, int numberOfSegment, double length, GrainSurface endSurface) {
        this.rodDiameter = rodDiameter;
        this.tubeOuterDiameter = tubeOuterDiameter;
        this.tubeInnerDiameter = tubeInnerDiameter;
        this.numberOfSegment = numberOfSegment;
        this.length = length;
        this.endSurface = endSurface;
    }

    @Override
    public double getGrainEndSurface(double burnProgression) {
        return this.rodArea(burnProgression) + this.tubeArea(burnProgression);
    }

    @Override
    public double getGrainVolume(double burnProgression) {
        double grainLength = this.getGrainLength(burnProgression) * (double)this.numberOfSegment;
        return this.getGrainEndSurface(burnProgression) * grainLength;
    }

    @Override
    public double getBurningArea(double burnProgression) {
        double rodPerimeter = this.computeRodRadius(burnProgression) * 2.0 * Math.PI;
        double tubeInnerPerimeter = 0.0;
        double computeTubeInnerDiameter = this.computeTubeInnerDiameter(burnProgression);
        if (computeTubeInnerDiameter <= this.tubeOuterDiameter) {
            tubeInnerPerimeter = computeTubeInnerDiameter * Math.PI;
        }
        double endBurningSurfaces = 0.0;
        if (this.endSurface == GrainSurface.EXPOSED) {
            endBurningSurfaces = this.getGrainEndSurface(burnProgression) * 2.0 * (double)this.numberOfSegment;
        }
        return (rodPerimeter + tubeInnerPerimeter) * this.getGrainLength(burnProgression) * (double)this.numberOfSegment + endBurningSurfaces;
    }

    @Override
    public double getXincp(int numberOfPoints) {
        return this.webThickness() / (double)numberOfPoints;
    }

    public double webThickness() {
        double rodThickness = this.rodDiameter / 2.0;
        double tubeThickness = (this.tubeOuterDiameter - this.tubeInnerDiameter) / 2.0;
        return Math.max(rodThickness, tubeThickness);
    }

    private double rodArea(double burnProgression) {
        return Math.PI * Math.pow(this.computeRodRadius(burnProgression), 2.0);
    }

    private double computeRodRadius(double burnProgression) {
        double newRodRadius = this.rodDiameter / 2.0 - this.computeRegression(burnProgression);
        if (newRodRadius < 0.0) {
            return 0.0;
        }
        return newRodRadius;
    }

    private double computeRegression(double burnProgression) {
        return this.webThickness() * burnProgression;
    }

    private double tubeArea(double burnProgression) {
        double newTubeInnerDiameter = this.computeTubeInnerDiameter(burnProgression);
        if (newTubeInnerDiameter > this.tubeOuterDiameter) {
            return 0.0;
        }
        HollowCircleAreaFunction hollowCircleAreaFunction = new HollowCircleAreaFunction();
        return hollowCircleAreaFunction.runFunction(this.tubeOuterDiameter, newTubeInnerDiameter);
    }

    private double computeTubeInnerDiameter(double burnProgression) {
        double newTubeInnerDiameter = this.tubeInnerDiameter + 2.0 * this.computeRegression(burnProgression);
        return newTubeInnerDiameter;
    }

    private double getGrainLength(double burnProgression) {
        if (this.endSurface == GrainSurface.EXPOSED) {
            return this.length - 2.0 * this.computeRegression(burnProgression);
        }
        return this.length;
    }

    @Override
    public void checkConfiguration(SolidRocketMotor solidRocketMotor) throws InvalidMotorDesignException {
        if (this.rodDiameter <= 0.0) {
            throw new InvalidMotorDesignException("Rod diameter should be > 0");
        }
        if (this.rodDiameter >= this.tubeInnerDiameter) {
            throw new InvalidMotorDesignException("Rod diameter should be < than tube inner diameter");
        }
        if (this.tubeOuterDiameter <= 0.0) {
            throw new InvalidMotorDesignException("Tube outer diameter should be > 0");
        }
        if (this.tubeOuterDiameter <= this.tubeInnerDiameter) {
            throw new InvalidMotorDesignException("Tube outer diameter should be > than tube inner diameter");
        }
        if (this.tubeOuterDiameter > solidRocketMotor.getCombustionChamber().getChamberInnerDiameterInMillimeter()) {
            throw new InvalidMotorDesignException("Combution chamber diameter should be >= than tube outer diameter");
        }
        if (this.numberOfSegment <= 0) {
            throw new InvalidMotorDesignException("Number of segment should be > 0");
        }
        double webThickness = this.webThickness();
        if (this.length <= webThickness) {
            throw new InvalidMotorDesignException("Grain length should be > " + webThickness);
        }
        if (this.length * (double)this.numberOfSegment > solidRocketMotor.getCombustionChamber().getChamberLengthInMillimeter()) {
            throw new InvalidMotorDesignException("Combustion chamber length should be >= than Grain total length");
        }
    }
}

