/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application.motor.grain.core;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.HashSet;
import java.util.Set;

public class BurningShape {
    private double lastRegression = -1.0;
    private Area lastArea = null;
    private Set<ShapeAndTrans> plus = new HashSet<ShapeAndTrans>();
    private Set<ShapeAndTrans> minus = new HashSet<ShapeAndTrans>();
    private Set<ShapeAndTrans> inhibited = new HashSet<ShapeAndTrans>();

    public void add(Shape s) {
        this.plus.add(new ShapeAndTrans(s));
    }

    public void subtract(Shape s) {
        this.minus.add(new ShapeAndTrans(s));
    }

    public void subtract(Shape s, AffineTransform t) {
        this.minus.add(new ShapeAndTrans(s, t));
    }

    public void inhibit(Shape s) {
        this.inhibited.add(new ShapeAndTrans(s));
    }

    public Area getShape(double regression) {
        Shape s;
        if (regression == this.lastRegression) {
            return this.lastArea;
        }
        Area a = new Area();
        for (ShapeAndTrans st : this.plus) {
            s = st.shape;
            if (!this.inhibited.contains(st)) {
                s = this.regress(st.shape, regression, true);
            }
            if (st.trans != null) {
                s = st.trans.createTransformedShape(s);
            }
            a.add(new Area(s));
        }
        for (ShapeAndTrans st : this.minus) {
            s = st.shape;
            if (!this.inhibited.contains(st)) {
                s = this.regress(st.shape, regression, false);
            }
            if (st.trans != null) {
                s = st.trans.createTransformedShape(s);
            }
            a.subtract(new Area(s));
        }
        this.lastRegression = regression;
        this.lastArea = a;
        return a;
    }

    private Shape regress(Shape s, double mm, boolean plus) {
        if (s instanceof Ellipse2D) {
            Ellipse2D e = (Ellipse2D)s;
            double d = plus ? -2.0 * mm : 2.0 * mm;
            double w = e.getWidth() + d;
            double h = e.getHeight() + d;
            double x = e.getX() - d / 2.0;
            double y = e.getY() - d / 2.0;
            return new Ellipse2D.Double(x, y, w, h);
        }
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            if (plus) {
                double d = -2.0 * mm;
                double w = r.getWidth() + d;
                double h = r.getHeight() + d;
                double x = r.getX() - d / 2.0;
                double y = r.getY() - d / 2.0;
                return new Rectangle2D.Double(x, y, w, h);
            }
            Area a = new Area();
            double d = 2.0 * mm;
            a.add(new Area(new RoundRectangle2D.Double(r.getX() - d / 2.0, r.getY() - d / 2.0, r.getWidth() + d, r.getHeight() + d, d, d)));
            return a;
        }
        RegressableShape r = new RegressableShape(s);
        System.out.println("Warning: Complex (non circle / square) geometry slows me down.");
        return r.getRegressedShape(mm * (double)(plus ? -1 : 1));
    }

    private static class ShapeAndTrans {
        Shape shape;
        AffineTransform trans;

        ShapeAndTrans(Shape s, AffineTransform t) {
            this.shape = s;
            this.trans = t;
        }

        ShapeAndTrans(Shape s) {
            this.shape = s;
            this.trans = null;
        }

        public int hashCode() {
            if (this.trans != null) {
                return this.shape.hashCode() * this.trans.hashCode();
            }
            return this.shape.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ShapeAndTrans) {
                ShapeAndTrans s = (ShapeAndTrans)o;
                if (!s.shape.equals(this.shape)) {
                    return false;
                }
                if (s.trans == null && this.trans != null) {
                    return false;
                }
                if (s.trans != null && this.trans == null) {
                    return false;
                }
                return this.trans == null || this.trans.equals(s.trans);
            }
            return false;
        }
    }

    private static class RegressableShape {
        private Area a;

        public RegressableShape(Shape s) {
            if (s instanceof Area) {
                this.a = (Area)s;
            }
            this.a = new Area(s);
        }

        public Area getRegressedShape(double regression) {
            if (regression == 0.0) {
                return this.a;
            }
            Area rRect = new Area();
            Area rCirc = new Area();
            PathIterator i = this.a.getPathIterator(new AffineTransform(), 0.001);
            double[] last = new double[]{0.0, 0.0};
            double[] first = new double[]{0.0, 0.0};
            while (!i.isDone()) {
                double[] coords = new double[6];
                int type = i.currentSegment(coords);
                switch (type) {
                    case 0: {
                        first[0] = last[0] = coords[0];
                        first[1] = last[1] = coords[1];
                        break;
                    }
                    case 4: {
                        coords[0] = first[0];
                        coords[1] = first[1];
                    }
                    case 1: {
                        double dx = coords[0] - last[0];
                        double dy = coords[1] - last[1];
                        double len = Math.sqrt(dx * dx + dy * dy);
                        double[] normal = new double[]{-dy / len, dx / len};
                        double[] displacement = new double[]{regression * normal[0], regression * normal[1]};
                        GeneralPath p = new GeneralPath();
                        p.moveTo(last[0], last[1]);
                        p.lineTo(last[0] + displacement[0], last[1] + displacement[1]);
                        p.lineTo(coords[0] + displacement[0], coords[1] + displacement[1]);
                        p.lineTo(coords[0], coords[1]);
                        p.closePath();
                        rRect.add(new Area(p));
                        double er = Math.abs(regression);
                        rCirc.add(new Area(new Ellipse2D.Double(coords[0] - er, coords[1] - er, 2.0 * er, 2.0 * er)));
                        last[0] = coords[0];
                        last[1] = coords[1];
                        break;
                    }
                    case 2: 
                    case 3: {
                        throw new Error("Unflattend Geometry!");
                    }
                }
                i.next();
            }
            if (regression > 0.0) {
                rRect.add(this.a);
                rRect.add(rCirc);
            } else {
                Area acp = (Area)this.a.clone();
                acp.subtract(rRect);
                acp.subtract(rCirc);
                rRect = acp;
            }
            return rRect;
        }
    }
}

