/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.infra.performance;

import com.github.jbgust.jsrm.application.JSRMConfig;
import com.github.jbgust.jsrm.application.RegisteredPropellant;
import com.github.jbgust.jsrm.application.motor.SolidRocketMotor;
import com.github.jbgust.jsrm.calculation.CalculatorBuilder;
import com.github.jbgust.jsrm.calculation.CalculatorResults;
import com.github.jbgust.jsrm.calculation.Formula;
import com.github.jbgust.jsrm.calculation.ResultLineProvider;
import com.github.jbgust.jsrm.infra.ConstantsExtractor;
import com.github.jbgust.jsrm.infra.JSRMConstant;
import com.github.jbgust.jsrm.infra.performance.PerformanceCalculationResult;
import com.github.jbgust.jsrm.infra.performance.PerformanceFormulas;
import com.github.jbgust.jsrm.infra.performance.solver.MachSpeedAtNozzleExitSolver;
import com.github.jbgust.jsrm.infra.pressure.ChamberPressureCalculation;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PerformanceCalculation {
    private final SolidRocketMotor motor;
    private final Map<JSRMConstant, Double> constants;
    private final Map<Formula, Double> initialValues;
    private final ResultLineProvider chamberPressureMpaResultProvider;
    private final ResultLineProvider throatAreaResultProvider;
    private final ResultLineProvider nozzleCriticalPassageAreaResultProvider;
    private final ResultLineProvider timeResultProvider;

    public PerformanceCalculation(SolidRocketMotor motor, Map<JSRMConstant, Double> constants, ResultLineProvider chamberPressureMpaResultProvider, ResultLineProvider throatAreaResultProvider, ResultLineProvider nozzleCriticalPassageAreaResultProvider, ResultLineProvider timeResultProvider) {
        this.motor = motor;
        this.constants = new HashMap<JSRMConstant, Double>(constants);
        this.initialValues = this.getInitialValues(constants);
        this.chamberPressureMpaResultProvider = chamberPressureMpaResultProvider;
        this.throatAreaResultProvider = throatAreaResultProvider;
        this.nozzleCriticalPassageAreaResultProvider = nozzleCriticalPassageAreaResultProvider;
        this.timeResultProvider = timeResultProvider;
    }

    public PerformanceCalculationResult compute(JSRMConfig config) {
        double optimalNozzleExpansionRatio = this.getOptimalNozzleExpansionRatio(config);
        this.computeNozzleExitSpeed(config, optimalNozzleExpansionRatio);
        CalculatorResults performanceResults = new CalculatorBuilder(PerformanceFormulas.DELIVERED_IMPULSE).withConstants(ConstantsExtractor.toCalculationFormat(this.constants)).withInitialValues(this.initialValues).withResultLineProviders(this.chamberPressureMpaResultProvider, this.throatAreaResultProvider, this.nozzleCriticalPassageAreaResultProvider, this.timeResultProvider).withResultsToSave(PerformanceFormulas.THRUST, PerformanceFormulas.DELIVERED_IMPULSE).createCalculator().compute(0, config.getLastCalcultationLine());
        performanceResults.addResult(this.computeLastLine(config.getLastCalcultationLine(), performanceResults));
        return new PerformanceCalculationResult((Map<Results, List<Double>>)ImmutableMap.builder().put((Object)Results.thrust, performanceResults.getResults(PerformanceFormulas.THRUST)).put((Object)Results.deliveredImpulse, performanceResults.getResults(PerformanceFormulas.DELIVERED_IMPULSE)).build(), optimalNozzleExpansionRatio, this.constants.get((Object)JSRMConstant.me), this.constants.get((Object)JSRMConstant.mef), Math.sqrt(optimalNozzleExpansionRatio) * this.motor.getThroatDiameterInMillimeter(), Math.sqrt(4.0 * this.constants.get((Object)JSRMConstant.aexit) / Math.PI));
    }

    private void computeNozzleExitSpeed(JSRMConfig config, double optimalNozzleExpansionRatio) {
        double initialNozzleExpansionRatio = this.computeInitialNozzleExpansionRatio(config, optimalNozzleExpansionRatio);
        double nozzleExitArea = this.constants.get((Object)JSRMConstant.at) * initialNozzleExpansionRatio;
        MachSpeedAtNozzleExitSolver machSpeedAtNozzleExitSolver = new MachSpeedAtNozzleExitSolver(RegisteredPropellant.getSolidPropellant(this.constants.get((Object)JSRMConstant.propellantId).intValue()));
        double finalNozzleExpansionRation = nozzleExitArea / this.constants.get((Object)JSRMConstant.atfinal);
        this.constants.put(JSRMConstant.aexit, nozzleExitArea);
        this.constants.put(JSRMConstant.me, machSpeedAtNozzleExitSolver.solve(initialNozzleExpansionRatio));
        this.constants.put(JSRMConstant.mef, machSpeedAtNozzleExitSolver.solve(finalNozzleExpansionRation));
        this.initialValues.put(PerformanceFormulas.MACH_SPEED_AT_NOZZLE_EXIT, this.constants.get((Object)JSRMConstant.me));
    }

    private double computeInitialNozzleExpansionRatio(JSRMConfig config, double optimalNozzleExpansionRatio) {
        double initialNozzleExpansionRatio = config.isOptimalNozzleDesign() ? optimalNozzleExpansionRatio : config.getNozzleExpansionRatio();
        return initialNozzleExpansionRatio;
    }

    private Map<Formula, Double> computeLastLine(int lastLine, CalculatorResults performanceResults) {
        HashMap<Formula, Double> lastResultLine = new HashMap<Formula, Double>();
        lastResultLine.put(PerformanceFormulas.THRUST, 0.0);
        lastResultLine.put(PerformanceFormulas.DELIVERED_IMPULSE, PerformanceFormulas.DELIVERED_IMPULSE.getExpression().setVariable(PerformanceFormulas.THRUST.name(), 0.0).setVariable(PerformanceFormulas.THRUST.name() + "_previous", performanceResults.getResult(PerformanceFormulas.THRUST, lastLine - 1).doubleValue()).setVariable(ChamberPressureCalculation.Results.timeSinceBurnStart.name(), this.timeResultProvider.getResult(lastLine)).setVariable(ChamberPressureCalculation.Results.timeSinceBurnStart.name() + "_previous", this.timeResultProvider.getResult(lastLine - 1)).evaluate());
        return lastResultLine;
    }

    private double getOptimalNozzleExpansionRatio(JSRMConfig config) {
        List<Double> optimalNozzleRatioByTime = new CalculatorBuilder(PerformanceFormulas.OPTIMUM_NOZZLE_EXPANSION_RATIO).withConstants(ConstantsExtractor.toCalculationFormat(this.constants)).withInitialValues(this.initialValues).withResultLineProviders(this.chamberPressureMpaResultProvider).createCalculator().compute(0, config.getLastCalcultationLine()).getResults(PerformanceFormulas.OPTIMUM_NOZZLE_EXPANSION_RATIO);
        return optimalNozzleRatioByTime.stream().mapToDouble(Double::doubleValue).average().getAsDouble();
    }

    private Map<Formula, Double> getInitialValues(Map<JSRMConstant, Double> constants) {
        HashMap<Formula, Double> initialvalues = new HashMap<Formula, Double>();
        initialvalues.put(PerformanceFormulas.OPTIMUM_NOZZLE_EXPANSION_RATIO, 1.0);
        initialvalues.put(PerformanceFormulas.DELIVERED_THRUST_COEFFICIENT, constants.get((Object)JSRMConstant.etanoz));
        initialvalues.put(PerformanceFormulas.THRUST, 0.0);
        initialvalues.put(PerformanceFormulas.DELIVERED_IMPULSE, 0.0);
        return initialvalues;
    }

    public static enum Results {
        thrust,
        deliveredImpulse;

    }
}

