/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.infra.performance.solver;

import com.github.jbgust.jsrm.application.motor.propellant.SolidPropellant;
import com.github.jbgust.jsrm.infra.JSRMConstant;
import com.google.common.collect.Range;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

public class MachSpeedAtNozzleExitSolver {
    private static final String INITIAL_MACH_SPEED_VARIABLE = "me";
    private static final double MIN_MACH_EXIT_SPEED = 0.2;
    private static final double MAX_MACH_EXIT_SPEED = 10.0;
    private static final double SOLVER_PRECISION = 1.0E-4;
    private static final int MAX_DICHOTOMIC_LOOP = 100;
    private static final String NOZZLE_EXPANSION_RATION_VARIABLE = "nozzleExpansionRation";
    private final Range<Double> EXPECTED_RESULT_RANGE = Range.closed((Comparable)Double.valueOf(-1.0E-4), (Comparable)Double.valueOf(1.0E-4));
    private final Expression expression;
    private final SolidPropellant solidPropellant;

    public MachSpeedAtNozzleExitSolver(SolidPropellant solidPropellant) {
        this.solidPropellant = solidPropellant;
        this.expression = new ExpressionBuilder("nozzleExpansionRation-1/me*((1+(k-1)/2*me^2)/(1+(k-1)/2))^((k+1)/2/(k-1))").variables(new String[]{NOZZLE_EXPANSION_RATION_VARIABLE, JSRMConstant.k.name(), INITIAL_MACH_SPEED_VARIABLE}).build();
    }

    public double solve(double nozzleExpansionRation) {
        return nozzleExpansionRation < 2.0 ? this.slowMachSpeedSolver(nozzleExpansionRation) : this.fastMachSpeedSolverSolver(nozzleExpansionRation);
    }

    private double fastMachSpeedSolverSolver(double nozzleExpansionRation) {
        boolean isSolved = false;
        this.expression.setVariable(JSRMConstant.k.name(), this.solidPropellant.getK());
        this.expression.setVariable(NOZZLE_EXPANSION_RATION_VARIABLE, nozzleExpansionRation);
        Range initialMachSpeedAtNozzleExitRange = Range.closed((Comparable)Double.valueOf(0.2), (Comparable)Double.valueOf(10.0));
        double machSpeedAtNozzleExit = 0.0;
        try {
            return this.dichotomicSolve(isSolved, (Range<Double>)initialMachSpeedAtNozzleExitRange);
        }
        catch (DichotomicSolveFailedException e) {
            return this.slowMachSpeedSolver(nozzleExpansionRation);
        }
    }

    private double dichotomicSolve(boolean isSolved, Range<Double> initialMachSpeedAtNozzleExitRange) throws DichotomicSolveFailedException {
        double machSpeedAtNozzleExit = -1.0;
        int iteration = 0;
        while (!isSolved) {
            if (iteration > 100) {
                throw new DichotomicSolveFailedException();
            }
            machSpeedAtNozzleExit = (Double)initialMachSpeedAtNozzleExitRange.lowerEndpoint() + ((Double)initialMachSpeedAtNozzleExitRange.upperEndpoint() - (Double)initialMachSpeedAtNozzleExitRange.lowerEndpoint()) / 2.0;
            double result = this.expression.setVariable(INITIAL_MACH_SPEED_VARIABLE, machSpeedAtNozzleExit).evaluate();
            if (this.EXPECTED_RESULT_RANGE.contains((Comparable)Double.valueOf(result))) {
                isSolved = true;
            } else {
                initialMachSpeedAtNozzleExitRange = result < 0.0 ? Range.closed((Comparable)((Double)initialMachSpeedAtNozzleExitRange.lowerEndpoint()), (Comparable)Double.valueOf(machSpeedAtNozzleExit)) : Range.closed((Comparable)Double.valueOf(machSpeedAtNozzleExit), (Comparable)((Double)initialMachSpeedAtNozzleExitRange.upperEndpoint()));
            }
            ++iteration;
        }
        return machSpeedAtNozzleExit;
    }

    private double slowMachSpeedSolver(double nozzleExpansionRation) {
        if (nozzleExpansionRation == 1.0) {
            return 1.0;
        }
        this.expression.setVariable(JSRMConstant.k.name(), this.solidPropellant.getK());
        this.expression.setVariable(NOZZLE_EXPANSION_RATION_VARIABLE, nozzleExpansionRation);
        LinkedHashMap<Double, Double> result = new LinkedHashMap<Double, Double>();
        for (double machSpeedAtNozzleExit = 0.5; machSpeedAtNozzleExit < 10.0; machSpeedAtNozzleExit += 1.0E-4) {
            result.put(machSpeedAtNozzleExit, Math.abs(this.expression.setVariable(INITIAL_MACH_SPEED_VARIABLE, machSpeedAtNozzleExit).evaluate()));
        }
        return (Double)result.entrySet().stream().min(Comparator.comparingDouble(Map.Entry::getValue)).get().getKey();
    }

    private class DichotomicSolveFailedException
    extends Exception {
        private DichotomicSolveFailedException() {
        }
    }
}

