/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmatsu.multipreference;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.jmatsu.multipreference.DataStore;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class InMemoryDataStore
implements DataStore {
    @NonNull
    private final Map<String, Object> map = new ConcurrentHashMap<String, Object>();
    @Nullable
    private Map<String, Object> temporaryMapForTransaction;

    private static <T> T getOrDefault(@NonNull Map<String, ?> map, @NonNull String key, @Nullable T defaultValue2) {
        Object value = map.get(key);
        if (value != null) {
            return (T)value;
        }
        return defaultValue2;
    }

    InMemoryDataStore() {
    }

    @Override
    @NonNull
    public Map<String, ?> getAll() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public boolean contains(@NonNull String key) {
        return this.map.containsKey(key);
    }

    @Override
    @Nullable
    public String getNullableString(@NonNull String key, @Nullable String defaultValue2) {
        return InMemoryDataStore.getOrDefault(this.map, key, defaultValue2);
    }

    @Override
    @NonNull
    public String getNonNullString(@NonNull String key, @NonNull String defaultValue2) {
        return InMemoryDataStore.getOrDefault(this.map, key, defaultValue2);
    }

    @Override
    @Nullable
    public Set<String> getNullableStringSet(@NonNull String key, @Nullable Set<String> defaultValue2) {
        return InMemoryDataStore.getOrDefault(this.map, key, defaultValue2);
    }

    @Override
    @NonNull
    public Set<String> getNonNullStringSet(@NonNull String key, @NonNull Set<String> defaultValue2) {
        return InMemoryDataStore.getOrDefault(this.map, key, defaultValue2);
    }

    @Override
    public int getInt(@NonNull String key, int defaultValue2) {
        return InMemoryDataStore.getOrDefault(this.map, key, defaultValue2);
    }

    @Override
    public long getLong(@NonNull String key, long defaultValue2) {
        return InMemoryDataStore.getOrDefault(this.map, key, defaultValue2);
    }

    @Override
    public float getFloat(@NonNull String key, float defaultValue2) {
        return InMemoryDataStore.getOrDefault(this.map, key, Float.valueOf(defaultValue2)).floatValue();
    }

    @Override
    public boolean getBoolean(@NonNull String key, boolean defaultValue2) {
        return InMemoryDataStore.getOrDefault(this.map, key, defaultValue2);
    }

    @Override
    public void setNullableString(@NonNull String key, @Nullable String value) {
        this.putOrRemoveVal(key, value);
    }

    @Override
    public void setNonNullString(@NonNull String key, @NonNull String value) {
        this.putOrRemoveVal(key, value);
    }

    @Override
    public void setNullableStringSet(@NonNull String key, @Nullable Set<String> value) {
        this.putOrRemoveVal(key, value);
    }

    @Override
    public void setNonNullStringSet(@NonNull String key, @NonNull Set<String> value) {
        this.putOrRemoveVal(key, value);
    }

    @Override
    public void setInt(@NonNull String key, int value) {
        this.putOrRemoveVal(key, value);
    }

    @Override
    public void setLong(@NonNull String key, long value) {
        this.putOrRemoveVal(key, value);
    }

    @Override
    public void setFloat(@NonNull String key, float value) {
        this.putOrRemoveVal(key, Float.valueOf(value));
    }

    @Override
    public void setBoolean(@NonNull String key, boolean value) {
        this.putOrRemoveVal(key, value);
    }

    @Override
    public void beginTransaction() {
        if (this.isInTransaction()) {
            throw new RuntimeException("Multiple transactions are not allowed.");
        }
        this.temporaryMapForTransaction = new ConcurrentHashMap<String, Object>();
    }

    @Override
    public synchronized boolean finishTransaction(boolean commit) {
        if (!this.isInTransaction()) {
            return false;
        }
        if (this.temporaryMapForTransaction == null) {
            return false;
        }
        this.map.putAll(this.temporaryMapForTransaction);
        this.temporaryMapForTransaction = null;
        return true;
    }

    @Override
    public synchronized void cancelTransaction() {
        if (!this.isInTransaction()) {
            return;
        }
        this.temporaryMapForTransaction = null;
    }

    @Override
    public boolean isInTransaction() {
        return this.temporaryMapForTransaction != null;
    }

    @Override
    public void clear() {
        this.temporaryMapForTransaction = null;
        this.map.clear();
    }

    @Override
    public void destroySelf() {
        this.clear();
    }

    @Override
    public boolean isDestroyed() {
        return false;
    }

    private void putOrRemoveVal(@NonNull String key, @Nullable Object value) {
        if (value != null) {
            this.getMapToBeUpdated().put(key, value);
        } else {
            this.getMapToBeUpdated().remove(key);
        }
    }

    @NonNull
    private Map<String, Object> getMapToBeUpdated() {
        return this.temporaryMapForTransaction != null ? this.temporaryMapForTransaction : this.map;
    }
}

