/*
 * Decompiled with CFR 0.152.
 */
package com.github.johnnyjayjay.discord.commandapi;

import com.github.johnnyjayjay.discord.commandapi.CommandListener;
import com.github.johnnyjayjay.discord.commandapi.CommandSetException;
import com.github.johnnyjayjay.discord.commandapi.ICommand;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.dv8tion.jda.bot.sharding.ShardManager;
import net.dv8tion.jda.core.JDA;

public class CommandSettings {
    private final String INVALID_PREFIX_MESSAGE = "Prefix cannot be empty or contain the characters +*^|$\\?";
    private final String INVALID_LABEL_MESSAGE = "Label cannot be empty, consist of multiple words or contain new lines!";
    public static final String VALID_PREFIX = "([^\\\\+*^|$?])+";
    public static final String VALID_LABEL = "([^\\s\\n\\t])+";
    private String defaultPrefix;
    private Set<String> helpLabels;
    private Map<Long, String> prefixMap;
    private Map<String, ICommand> commands = new HashMap<String, ICommand>();
    private Object jda;
    private CommandListener listener = new CommandListener(this);
    private boolean activated = false;
    private boolean useShardManager;
    private boolean labelIgnoreCase;

    public CommandSettings(@Nonnull String defaultPrefix, @Nonnull ShardManager shardManager, boolean labelIgnoreCase) {
        this(defaultPrefix, labelIgnoreCase);
        this.jda = shardManager;
        this.useShardManager = true;
    }

    public CommandSettings(@Nonnull String defaultPrefix, @Nonnull JDA jda, boolean labelIgnoreCase) {
        this(defaultPrefix, labelIgnoreCase);
        this.jda = jda;
        this.useShardManager = false;
    }

    private CommandSettings(@Nonnull String defaultPrefix, boolean labelIgnoreCase) {
        this.setDefaultPrefix(defaultPrefix);
        this.labelIgnoreCase = labelIgnoreCase;
        this.helpLabels = new HashSet<String>();
        this.prefixMap = new HashMap<Long, String>();
    }

    public CommandSettings setHelpLabels(String ... labels) {
        for (String label : labels) {
            if (!label.matches(VALID_LABEL)) {
                throw new CommandSetException("Label cannot be empty, consist of multiple words or contain new lines!");
            }
            this.helpLabels.add(label);
        }
        return this;
    }

    public CommandSettings put(@Nonnull ICommand executor, @Nonnull String label) {
        if (!label.matches(VALID_LABEL)) {
            throw new CommandSetException("Label cannot be empty, consist of multiple words or contain new lines!");
        }
        this.commands.put(this.labelIgnoreCase ? label.toLowerCase() : label, executor);
        return this;
    }

    public CommandSettings put(@Nonnull ICommand executor, String ... labels) {
        for (String label : labels) {
            this.put(executor, label);
        }
        return this;
    }

    public boolean remove(@Nonnull String label) {
        return this.commands.remove(this.labelIgnoreCase ? label.toLowerCase() : label) != null;
    }

    public boolean remove(String ... labels) {
        boolean success = true;
        for (String label : labels) {
            if (this.remove(label)) continue;
            success = false;
        }
        return success;
    }

    public void setDefaultPrefix(@Nonnull String prefix) {
        if (!prefix.matches(VALID_PREFIX)) {
            throw new CommandSetException("Prefix cannot be empty or contain the characters +*^|$\\?");
        }
        this.defaultPrefix = prefix;
    }

    public void setCustomPrefix(long guildId, @Nonnull String prefix) {
        if (prefix != null && !prefix.matches(VALID_PREFIX)) {
            throw new CommandSetException("Prefix cannot be empty or contain the characters +*^|$\\?");
        }
        this.prefixMap.put(guildId, prefix);
    }

    public void activate() {
        if (!this.activated) {
            if (this.useShardManager) {
                ((ShardManager)this.jda).addEventListener(new Object[]{this.listener});
            } else {
                ((JDA)this.jda).addEventListener(new Object[]{this.listener});
            }
        } else {
            throw new CommandSetException("CommandSettings already activated!");
        }
        this.activated = true;
    }

    public void deactivate() {
        if (this.activated) {
            if (this.useShardManager) {
                ((ShardManager)this.jda).removeEventListener(new Object[]{this.listener});
            } else {
                ((JDA)this.jda).removeEventListener(new Object[]{this.listener});
            }
        } else {
            throw new CommandSetException("CommandSettings weren't activated yet and can therefore not be deactivated!");
        }
        this.activated = false;
    }

    public String getPrefix(long guildId) {
        return this.prefixMap.get(guildId) != null ? this.prefixMap.get(guildId) : this.defaultPrefix;
    }

    public String getPrefix() {
        return this.defaultPrefix;
    }

    protected boolean labelIgnoreCase() {
        return this.labelIgnoreCase;
    }

    protected Set<String> getHelpLabels() {
        return this.helpLabels;
    }

    protected Map<String, ICommand> getCommands() {
        return this.commands;
    }
}

