/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.clerezza;

import com.github.jsonldjava.clerezza.ClerezzaRDFParser;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.RDFParser;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.serializedform.SerializingProvider;
import org.apache.clerezza.rdf.core.serializedform.SupportedFormat;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportedFormat(value={"application/ld+json", "application/json"})
@Component(immediate=true, policy=ConfigurationPolicy.OPTIONAL)
@Service
public class ClerezzaJsonLdSerializingProvider
implements SerializingProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String MODE_EXPAND = "expand";
    private static final String MODE_FLATTEN = "flatten";
    private static final String MODE_COMPACT = "compact";
    @Property(value={""}, options={@PropertyOption(value="%mode.option.none", name=""), @PropertyOption(value="%mode.option.flatten", name="flatten"), @PropertyOption(value="%mode.option.compact", name="compact"), @PropertyOption(value="%mode.option.expand", name="expand")})
    private static final String PROP_MODE = "mode";
    @Property(boolValue={false})
    private static final String PROP_USE_RDF_TYPE = "useRdfTye";
    @Property(boolValue={false})
    private static final String PROP_USE_NATIVE_TYPES = "useNativeTypes";
    @Property(boolValue={true})
    private static final String PROP_PRETTY_PRINT = "prettyPrint";
    private static Map<String, String> DEFAULT_NAMESPACES;
    private JsonLdOptions opts = null;
    private String mode;
    private boolean prettyPrint;

    public void serialize(OutputStream serializedGraph, TripleCollection tc, String formatIdentifier) {
        ClerezzaRDFParser serializer = new ClerezzaRDFParser();
        try {
            long start = System.currentTimeMillis();
            Object output = JsonLdProcessor.fromRDF((Object)tc, (RDFParser)serializer);
            if (MODE_EXPAND.equalsIgnoreCase(this.mode)) {
                this.logger.debug(" - mode: {}", (Object)MODE_EXPAND);
                output = JsonLdProcessor.expand((Object)output, (JsonLdOptions)this.opts);
            }
            if (MODE_FLATTEN.equalsIgnoreCase(this.mode)) {
                this.logger.debug(" - mode: {}", (Object)MODE_FLATTEN);
                Object inframe = null;
                output = JsonLdProcessor.flatten((Object)output, inframe, (JsonLdOptions)this.opts);
            }
            if (MODE_COMPACT.equalsIgnoreCase(this.mode)) {
                this.logger.debug(" - mode: {}", (Object)MODE_COMPACT);
                HashMap<String, Map<String, String>> localCtx = new HashMap<String, Map<String, String>>();
                localCtx.put("@context", DEFAULT_NAMESPACES);
                output = JsonLdProcessor.compact((Object)output, localCtx, (JsonLdOptions)this.opts);
            }
            OutputStreamWriter writer = new OutputStreamWriter(serializedGraph, UTF8);
            this.logger.debug(" - prettyPrint: {}", (Object)this.prettyPrint);
            if (this.prettyPrint) {
                JsonUtils.writePrettyPrint((Writer)writer, (Object)output);
            } else {
                JsonUtils.write((Writer)writer, (Object)output);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" - serialized {} triples in {}ms", (Object)serializer.getCount(), (Object)(System.currentTimeMillis() - start));
            }
        }
        catch (JsonLdError e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Activate
    protected void activate(ComponentContext ctx) {
        this.opts = new JsonLdOptions();
        Dictionary config = ctx.getProperties();
        this.opts.setUseRdfType(Boolean.valueOf(this.getState(config.get(PROP_USE_RDF_TYPE), false)));
        this.opts.setUseNativeTypes(Boolean.valueOf(this.getState(config.get(PROP_USE_NATIVE_TYPES), false)));
        this.prettyPrint = this.getState(config.get(PROP_PRETTY_PRINT), true);
        Object value = config.get(PROP_MODE);
        this.mode = value == null ? null : value.toString();
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        this.opts = null;
        this.mode = null;
        this.prettyPrint = false;
    }

    private boolean getState(Object value, boolean defaultState) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value != null) {
            return Boolean.parseBoolean(value.toString());
        }
        return defaultState;
    }

    static {
        LinkedHashMap<String, String> ns = new LinkedHashMap<String, String>();
        ns.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        ns.put("owl", "http://www.w3.org/2002/07/owl#");
        ns.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        ns.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        ns.put("skos", "http://www.w3.org/2004/02/skos/core#");
        ns.put("geo", "http://www.w3.org/2003/01/geo/wgs84_pos#");
        ns.put("dc", "http://purl.org/dc/elements/1.1/");
        ns.put("foaf", "http://xmlns.com/foaf/0.1/");
        ns.put("ma", "http://www.w3.org/ns/ma-ont#");
        ns.put("dbo", "http://dbpedia.org/ontology/");
        ns.put("dbp", "http://dbpedia.org/property/");
        ns.put("yago", "http://yago-knowledge.org/resource/");
        ns.put("fb", "http://rdf.freebase.com/ns/");
        ns.put("geonames", "http://www.geonames.org/ontology#");
        ns.put("fise", "http://fise.iks-project.eu/ontology/");
        ns.put("enhancer", "http://stanbol.apache.org/ontology/enhancer/enhancer#");
        ns.put("entityhub", "http://stanbol.apache.org/ontology/entityhub/entityhub#");
        DEFAULT_NAMESPACES = Collections.unmodifiableMap(ns);
    }
}

