/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.jena;

import com.github.jsonldjava.core.JsonLdApi;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.jena.JenaJSONLD;
import com.github.jsonldjava.utils.JsonUtils;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.junit.Ignore;
import org.junit.Test;

public class ExampleTest {
    @Ignore(value="Integration test")
    @Test
    public void jsonldToTurtleRIOT() throws Exception {
        JenaJSONLD.init();
        String url = "http://json-ld.org/test-suite/tests/expand-0002-in.jsonld";
        Model model = RDFDataMgr.loadModel((String)"http://json-ld.org/test-suite/tests/expand-0002-in.jsonld");
        ByteArrayInputStream inStream = new ByteArrayInputStream("{}".getBytes("UTF-8"));
        RDFDataMgr.read((Model)model, (InputStream)inStream, (String)"http://example.com/", (Lang)JenaJSONLD.JSONLD);
        RDFDataMgr.write((OutputStream)System.out, (Model)model, (Lang)Lang.TURTLE);
    }

    @Test
    public void modelTojsonldRIOT() throws Exception {
        JenaJSONLD.init();
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://example.com/test");
        Property property = model.createProperty("http://example.com/value");
        model.add(resource, property, "Test");
        RDFDataMgr.write((OutputStream)System.out, (Model)model, (Lang)JenaJSONLD.JSONLD);
        RDFDataMgr.write((OutputStream)System.out, (Model)model, (RDFFormat)JenaJSONLD.JSONLD_FORMAT_FLAT);
        Dataset dataset = DatasetFactory.createMem();
        dataset.addNamedModel("http://example.com/graph", model);
        RDFDataMgr.write((OutputStream)System.out, (Dataset)dataset, (Lang)JenaJSONLD.JSONLD);
    }

    @Test
    public void modelToJsonldClassic() throws Exception {
        JenaJSONLD.init();
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://example.com/test");
        Property property = model.createProperty("http://example.com/value");
        model.add(resource, property, "Test");
        model.write((OutputStream)System.out, "JSON-LD");
        model.write((OutputStream)System.out, "JSON-LD", "http://example.com/");
    }

    @Ignore(value="Integration test")
    @Test
    public void jsonldToTurtleClassic() throws Exception {
        JenaJSONLD.init();
        String url = "http://json-ld.org/test-suite/tests/expand-0002-in.jsonld";
        Model model = ModelFactory.createDefaultModel();
        model.read("http://json-ld.org/test-suite/tests/expand-0002-in.jsonld", "JSON-LD");
        model.write((OutputStream)System.out, "TURTLE", "http://example.com/");
    }

    @Test
    public void modelToJsonLD() throws Exception {
        JenaJSONLD.init();
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://example.com/test");
        Property property = model.createProperty("http://example.com/value");
        model.add(resource, property, "Test");
        JsonLdOptions options = new JsonLdOptions();
        options.format = "application/ld+json";
        JsonLdApi api = new JsonLdApi(options);
        RDFDataset dataset = new RDFDataset(api);
        List json = api.fromRDF(dataset);
        String jsonStr = JsonUtils.toPrettyString((Object)json);
        System.out.println(jsonStr);
    }
}

