/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.jena;

import com.github.jsonldjava.jena.JenaJSONLD;
import com.github.jsonldjava.utils.TestUtils;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.lib.DatasetLib;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class JenaRiotReadWriteTest {
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    private File testDir;

    @BeforeClass
    public static void init() {
        JenaJSONLD.init();
    }

    private static boolean isIsomorphic(Dataset ds1, Dataset ds2) {
        return DatasetLib.isomorphic((Dataset)ds1, (Dataset)ds2);
    }

    @Before
    public void setUp() throws Exception {
        this.testDir = this.tempDir.newFolder("jenarioreadwritetest");
    }

    @Test
    public void read_ds01() throws Exception {
        this.datasetJ2R("graph1.jsonld", "graph1.ttl");
    }

    @Test
    public void read_ds02() throws Exception {
        this.datasetJ2R("dataset1.jsonld", "dataset1.trig");
    }

    @Test
    public void read_g01() throws Exception {
        this.graphJ2R("graph1.jsonld", "graph1.ttl");
    }

    @Test
    public void roundtrip_01() throws Exception {
        this.rtRJRg("graph1.ttl");
    }

    @Test
    public void roundtrip_02() throws Exception {
        this.rtRJRds("graph1.ttl");
    }

    @Test
    public void roundtrip_03() throws Exception {
        this.rtRJRds("dataset1.trig");
    }

    private void datasetJ2R(String inResource, String outResource) throws Exception {
        Dataset ds1 = this.loadDatasetFromClasspathResource("/com/github/jsonldjava/jena/" + inResource);
        Dataset ds2 = this.loadDatasetFromClasspathResource("/com/github/jsonldjava/jena/" + outResource);
        Assert.assertTrue((String)("Input dataset " + inResource + " not isomorphic to output dataset" + outResource), (boolean)JenaRiotReadWriteTest.isIsomorphic(ds1, ds2));
    }

    private void graphJ2R(String inResource, String outResource) throws Exception {
        Model model1 = this.loadModelFromClasspathResource("/com/github/jsonldjava/jena/" + inResource);
        Assert.assertFalse((String)("Failed to load input model from classpath: " + inResource), (boolean)model1.isEmpty());
        Model model2 = this.loadModelFromClasspathResource("/com/github/jsonldjava/jena/" + outResource);
        Assert.assertFalse((String)("Failed to load output model from classpath: " + outResource), (boolean)model2.isEmpty());
        Assert.assertTrue((String)("Input graph " + inResource + " not isomorphic to output dataset" + outResource), (boolean)model1.isIsomorphicWith(model2));
    }

    private Dataset loadDatasetFromClasspathResource(String resource) throws Exception {
        InputStream url = this.getClass().getResourceAsStream(resource);
        Assert.assertNotNull((String)("Could not find resource on classpath: " + resource), (Object)url);
        return RDFDataMgr.loadDataset((String)TestUtils.copyResourceToFile((File)this.testDir, (String)resource));
    }

    private Model loadModelFromClasspathResource(String resource) throws Exception {
        InputStream url = this.getClass().getResourceAsStream(resource);
        Assert.assertNotNull((String)("Could not find resource on classpath: " + resource), (Object)url);
        return RDFDataMgr.loadModel((String)TestUtils.copyResourceToFile((File)this.testDir, (String)resource));
    }

    private void rtRJRds(String resource) throws Exception {
        Dataset ds1 = this.loadDatasetFromClasspathResource("/com/github/jsonldjava/jena/" + resource);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)out, (Dataset)ds1, (Lang)JenaJSONLD.JSONLD);
        ByteArrayInputStream r = new ByteArrayInputStream(out.toByteArray());
        Dataset ds2 = DatasetFactory.createMem();
        RDFDataMgr.read((Dataset)ds2, (InputStream)r, null, (Lang)JenaJSONLD.JSONLD);
        if (!JenaRiotReadWriteTest.isIsomorphic(ds1, ds2)) {
            SSE.write((Dataset)ds1);
            SSE.write((Dataset)ds2);
        }
        Assert.assertTrue((String)("Input dataset " + resource + " not isomorphic with roundtrip dataset"), (boolean)JenaRiotReadWriteTest.isIsomorphic(ds1, ds2));
    }

    private void rtRJRg(String filename) throws Exception {
        Model model = this.loadModelFromClasspathResource("/com/github/jsonldjava/jena/" + filename);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)out, (Model)model, (Lang)JenaJSONLD.JSONLD);
        ByteArrayInputStream r = new ByteArrayInputStream(out.toByteArray());
        Model model2 = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)model2, (InputStream)r, null, (Lang)JenaJSONLD.JSONLD);
        Assert.assertFalse((String)"JSON-LD model was empty", (boolean)model2.isEmpty());
        if (!model.isIsomorphicWith(model2)) {
            System.out.println("## ---- DIFFERENT");
        }
    }
}

