/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.rdf2go;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.RDFParser;
import com.github.jsonldjava.rdf2go.RDF2GoRDFParser;
import com.github.jsonldjava.utils.Obj;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Syntax;

public class RDF2GoRDFParserTest {
    @Test
    public void testFromRDF() throws JsonLdError, IOException {
        String turtle = "@prefix const: <http://foo.com/> .\n@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n<http://localhost:8080/foo1> const:code \"123\" .\n<http://localhost:8080/foo2> const:code \"23.3364\"^^xsd:decimal .\n<http://localhost:8080/foo3> const:code \"ABC\"^^xsd:string .\n<http://localhost:8080/foo4> const:code \"English\"@en .\n";
        ArrayList<Map<String, Object>> expected = new ArrayList<Map<String, Object>>(){
            {
                this.add(new LinkedHashMap<String, Object>(){
                    {
                        this.put("@id", "http://localhost:8080/foo1");
                        this.put("http://foo.com/code", new ArrayList<Object>(){
                            {
                                this.add(new LinkedHashMap<String, Object>(){
                                    {
                                        this.put("@value", "123");
                                    }
                                });
                            }
                        });
                    }
                });
                this.add(new LinkedHashMap<String, Object>(){
                    {
                        this.put("@id", "http://localhost:8080/foo2");
                        this.put("http://foo.com/code", new ArrayList<Object>(){
                            {
                                this.add(new LinkedHashMap<String, Object>(){
                                    {
                                        this.put("@value", "23.3364");
                                        this.put("@type", "http://www.w3.org/2001/XMLSchema#decimal");
                                    }
                                });
                            }
                        });
                    }
                });
                this.add(new LinkedHashMap<String, Object>(){
                    {
                        this.put("@id", "http://localhost:8080/foo3");
                        this.put("http://foo.com/code", new ArrayList<Object>(){
                            {
                                this.add(new LinkedHashMap<String, Object>(){
                                    {
                                        this.put("@value", "ABC");
                                    }
                                });
                            }
                        });
                    }
                });
                this.add(new LinkedHashMap<String, Object>(){
                    {
                        this.put("@id", "http://localhost:8080/foo4");
                        this.put("http://foo.com/code", new ArrayList<Object>(){
                            {
                                this.add(new LinkedHashMap<String, Object>(){
                                    {
                                        this.put("@value", "English");
                                        this.put("@language", "en");
                                    }
                                });
                            }
                        });
                    }
                });
            }
        };
        RDF2GoRDFParser parser = new RDF2GoRDFParser();
        Model modelResult = RDF2Go.getModelFactory().createModel().open();
        modelResult.readFrom((InputStream)new ByteArrayInputStream("@prefix const: <http://foo.com/> .\n@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n<http://localhost:8080/foo1> const:code \"123\" .\n<http://localhost:8080/foo2> const:code \"23.3364\"^^xsd:decimal .\n<http://localhost:8080/foo3> const:code \"ABC\"^^xsd:string .\n<http://localhost:8080/foo4> const:code \"English\"@en .\n".getBytes()), Syntax.Turtle);
        Object json = JsonLdProcessor.fromRDF((Object)modelResult, (RDFParser)parser);
        Assert.assertTrue((boolean)Obj.equals((Object)json, (Object)expected));
    }
}

