/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.rdf2go;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.rdf2go.RDF2GoTripleCallback;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.model.ModelSet;
import org.ontoware.rdf2go.model.Statement;

public class RDF2GoTripleCallbackTest {
    @Test
    public void testToRDF() throws JsonLdError, IOException {
        String inputstring = "{ `@id`:`http://nonexistent.com/abox#Document1823812`, `@type`:`http://nonexistent.com/tbox#Document` }".replace('`', '\"');
        String expectedString = "null - http://nonexistent.com/abox#Document1823812 - http://www.w3.org/1999/02/22-rdf-syntax-ns#type - http://nonexistent.com/tbox#Document";
        Object input = JsonUtils.fromString((String)inputstring);
        RDF2GoTripleCallback callback = new RDF2GoTripleCallback();
        ModelSet model = (ModelSet)JsonLdProcessor.toRDF((Object)input, (JsonLdTripleCallback)callback);
        ClosableIterator statements = model.iterator();
        Statement stmt = (Statement)statements.next();
        Assert.assertEquals((Object)"null - http://nonexistent.com/abox#Document1823812 - http://www.w3.org/1999/02/22-rdf-syntax-ns#type - http://nonexistent.com/tbox#Document", (Object)(stmt.getContext() + " - " + stmt.toString()));
        Assert.assertFalse((String)"Deserialized RDF contains more triples than expected", (boolean)statements.hasNext());
    }
}

