/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.impl;

import com.github.jsonldjava.core.JSONLD;
import com.github.jsonldjava.core.JSONLDProcessingError;
import com.github.jsonldjava.core.JSONLDTripleCallback;
import com.github.jsonldjava.impl.SesameTripleCallback;
import com.github.jsonldjava.utils.JSONUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.helpers.RDFParserBase;

public class SesameJSONLDParser
extends RDFParserBase
implements RDFParser {
    public SesameJSONLDParser() {
    }

    public SesameJSONLDParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.JSONLD;
    }

    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        SesameTripleCallback callback = new SesameTripleCallback(this.getRDFHandler(), this.valueFactory, this.getParserConfig(), this.getParseErrorListener());
        try {
            JSONLD.toRDF((Object)JSONUtils.fromInputStream((InputStream)in), (JSONLDTripleCallback)callback);
        }
        catch (JSONLDProcessingError e) {
            throw new RDFParseException("Could not parse JSONLD", (Throwable)e);
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof RDFParseException) {
                throw (RDFParseException)e.getCause();
            }
            throw e;
        }
    }

    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        SesameTripleCallback callback = new SesameTripleCallback(this.getRDFHandler(), this.valueFactory, this.getParserConfig(), this.getParseErrorListener());
        try {
            JSONLD.toRDF((Object)JSONUtils.fromReader((Reader)reader), (JSONLDTripleCallback)callback);
        }
        catch (JSONLDProcessingError e) {
            throw new RDFParseException("Could not parse JSONLD", (Throwable)e);
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof RDFParseException) {
                throw (RDFParseException)e.getCause();
            }
            throw e;
        }
    }
}

