/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain.crypto.ED25519;

import com.github.katenachain.crypto.AbstractKey;
import com.github.katenachain.crypto.ED25519.PublicKey;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Base64;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;

public class PrivateKey
extends AbstractKey {
    private EdDSANamedCurveSpec ed25519 = EdDSANamedCurveTable.getByName((String)"Ed25519");
    private PublicKey publicKey;

    public PrivateKey(byte[] privateKey) {
        super(privateKey);
        this.publicKey = new PublicKey(Arrays.copyOfRange(privateKey, 32, 64));
    }

    public PrivateKey(String privateKeyBase64) {
        this(Base64.getDecoder().decode(privateKeyBase64));
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] sign(byte[] message) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        EdDSAEngine signature = new EdDSAEngine(MessageDigest.getInstance(this.ed25519.getHashAlgorithm()));
        EdDSAPrivateKeySpec keySpec = new EdDSAPrivateKeySpec(Arrays.copyOfRange(this.key, 0, 32), (EdDSAParameterSpec)this.ed25519);
        EdDSAPrivateKey sKey = new EdDSAPrivateKey(keySpec);
        signature.initSign((java.security.PrivateKey)sKey);
        signature.update(message);
        return signature.sign();
    }
}

