/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain.crypto.Nacl;

import com.github.katenachain.crypto.AbstractKey;
import com.github.katenachain.crypto.Nacl.PublicKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.Hashtable;
import java.util.Random;
import org.abstractj.kalium.crypto.Box;

public class PrivateKey
extends AbstractKey {
    private PublicKey publicKey;

    public PrivateKey(byte[] key) {
        super(key);
        this.publicKey = new PublicKey(Arrays.copyOfRange(key, 32, 64));
    }

    public PrivateKey(String privateKeyBase64) {
        this(Base64.getDecoder().decode(privateKeyBase64));
    }

    public Hashtable<String, byte[]> seal(byte[] message, PublicKey publicKey) {
        Box box = new Box(publicKey.getKey(), Arrays.copyOfRange(this.key, 0, 32));
        Random rd = new Random();
        byte[] nonce = new byte[24];
        rd.nextBytes(nonce);
        byte[] encryptedMessage = box.encrypt(nonce, message);
        Hashtable<String, byte[]> result = new Hashtable<String, byte[]>();
        result.put("encryptedMessage", encryptedMessage);
        result.put("nonce", nonce);
        return result;
    }

    public byte[] open(byte[] encryptedMessage, PublicKey senderPublicKey, byte[] nonce) {
        Box box = new Box(senderPublicKey.getKey(), Arrays.copyOfRange(this.key, 0, 32));
        return box.decrypt(nonce, encryptedMessage);
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }
}

