/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain.serializer;

import com.github.katenachain.crypto.AbstractKey;
import com.github.katenachain.entity.TxData;
import com.github.katenachain.serializer.adapter.ByteArraySerializer;
import com.github.katenachain.serializer.adapter.CryptoKeySerializer;
import com.github.katenachain.serializer.adapter.GsonUTCDateAdapter;
import com.github.katenachain.serializer.adapter.TxDataSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Date;

public class Serializer {
    private GsonBuilder builder = new GsonBuilder();

    public Serializer() {
        this.builder.serializeNulls();
        this.builder.registerTypeAdapter(TxData.class, (Object)new TxDataSerializer());
        this.builder.registerTypeHierarchyAdapter(AbstractKey.class, (Object)new CryptoKeySerializer());
        this.builder.registerTypeAdapter(Date.class, (Object)new GsonUTCDateAdapter()).create();
        this.builder.registerTypeAdapter(byte[].class, (Object)new ByteArraySerializer()).create();
        this.builder.disableHtmlEscaping();
    }

    public String serialize(Object object) {
        Gson gson = this.builder.create();
        return gson.toJson(object);
    }

    public Object deserialize(String content, Class clazz) {
        Gson gson = this.builder.create();
        return gson.fromJson(content, clazz);
    }
}

