/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain;

import com.github.katenachain.api.Handler;
import com.github.katenachain.crypto.ED25519.PrivateKey;
import com.github.katenachain.crypto.ED25519.PublicKey;
import com.github.katenachain.entity.Tx;
import com.github.katenachain.entity.TxData;
import com.github.katenachain.entity.TxDataState;
import com.github.katenachain.entity.api.TxStatus;
import com.github.katenachain.entity.api.TxWrapper;
import com.github.katenachain.entity.api.TxWrappers;
import com.github.katenachain.entity.certify.CertificateEd25519V1;
import com.github.katenachain.entity.certify.CertificateRawV1;
import com.github.katenachain.entity.certify.Certify;
import com.github.katenachain.entity.certify.SecretNaclBoxV1;
import com.github.katenachain.exceptions.ApiException;
import com.github.katenachain.exceptions.ClientException;
import com.github.katenachain.serializer.Serializer;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Date;

public class Transactor {
    private PrivateKey txSigner;
    private Handler apiHandler;
    private String companyChainId;
    private String chainId;
    private Serializer serializer = new Serializer();

    public Transactor(String apiUrl, String chainId, String companyChainId, PrivateKey txSigner) {
        this.apiHandler = new Handler(apiUrl, this.serializer);
        this.chainId = chainId;
        this.txSigner = txSigner;
        this.companyChainId = companyChainId;
    }

    public Transactor(String apiUrl) {
        this.apiHandler = new Handler(apiUrl, this.serializer);
        this.chainId = "";
        this.txSigner = null;
        this.companyChainId = "";
    }

    public TxStatus sendCertificateRawV1(String uuid, byte[] value) throws IOException, ApiException, SignatureException, NoSuchAlgorithmException, InvalidKeyException, ClientException {
        CertificateRawV1 certificate = new CertificateRawV1(Certify.formatBcid(this.companyChainId, uuid), value);
        Tx tx = this.getTx(certificate);
        return this.apiHandler.sendCertificate(tx);
    }

    public TxStatus sendCertificateEd25519V1(String uuid, PublicKey signer, byte[] signature) throws IOException, ApiException, SignatureException, NoSuchAlgorithmException, InvalidKeyException, ClientException {
        CertificateEd25519V1 certificate = new CertificateEd25519V1(Certify.formatBcid(this.companyChainId, uuid), signature, signer);
        Tx tx = this.getTx(certificate);
        return this.apiHandler.sendCertificate(tx);
    }

    public TxWrapper retrieveCertificate(String companyChainId, String uuid) throws IOException, ApiException {
        return this.apiHandler.retrieveCertificate(Certify.formatBcid(companyChainId, uuid));
    }

    public TxWrappers retrieveCertificatesHistory(String companyChainId, String uuid) throws IOException, ApiException {
        return this.apiHandler.retrieveCertificatesHistory(Certify.formatBcid(companyChainId, uuid));
    }

    public TxStatus sendSecretNaclBoxV1(String uuid, com.github.katenachain.crypto.Nacl.PublicKey sender, byte[] nonce, byte[] content) throws IOException, ApiException, SignatureException, NoSuchAlgorithmException, InvalidKeyException, ClientException {
        SecretNaclBoxV1 secret = new SecretNaclBoxV1(content, Certify.formatBcid(this.companyChainId, uuid), nonce, sender);
        Tx tx = this.getTx(secret);
        return this.apiHandler.sendSecret(tx);
    }

    public TxWrappers retrieveSecrets(String companyChainId, String uuid) throws IOException, ApiException {
        return this.apiHandler.retrieveSecrets(Certify.formatBcid(companyChainId, uuid));
    }

    public Tx getTx(TxData txData) throws ClientException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (this.txSigner == null || this.companyChainId == null) {
            throw new ClientException("impossible to create txs without a private key or company chain id");
        }
        Date nonceTime = new Date();
        byte[] txDataState = this.getTxDataState(this.chainId, nonceTime, txData);
        return new Tx(txData, nonceTime, this.txSigner.sign(txDataState), this.txSigner.getPublicKey());
    }

    public byte[] getTxDataState(String chainId, Date nonceTime, TxData txData) {
        return this.serializer.serialize(new TxDataState(chainId, nonceTime, txData)).getBytes();
    }
}

