/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain;

import com.github.katenachain.api.Handler;
import com.github.katenachain.crypto.ED25519.PrivateKey;
import com.github.katenachain.crypto.ED25519.PublicKey;
import com.github.katenachain.entity.Tx;
import com.github.katenachain.entity.TxData;
import com.github.katenachain.entity.account.Account;
import com.github.katenachain.entity.account.KeyCreateV1;
import com.github.katenachain.entity.account.KeyRevokeV1;
import com.github.katenachain.entity.account.KeyV1;
import com.github.katenachain.entity.api.TxStatus;
import com.github.katenachain.entity.api.TxWrapper;
import com.github.katenachain.entity.api.TxWrappers;
import com.github.katenachain.entity.certify.CertificateEd25519V1;
import com.github.katenachain.entity.certify.CertificateRawV1;
import com.github.katenachain.entity.certify.SecretNaclBoxV1;
import com.github.katenachain.exceptions.ApiException;
import com.github.katenachain.exceptions.ClientException;
import com.github.katenachain.serializer.Serializer;
import com.github.katenachain.utils.Common;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Date;

public class Transactor {
    private PrivateKey txSigner;
    private Handler apiHandler;
    private String companyBcid;
    private String chainID;
    private Serializer serializer = new Serializer();

    public Transactor(String apiUrl, String chainID, String companyBcid, PrivateKey txSigner) {
        this.apiHandler = new Handler(apiUrl, this.serializer);
        this.chainID = chainID;
        this.txSigner = txSigner;
        this.companyBcid = companyBcid;
    }

    public Transactor(String apiUrl) {
        this.apiHandler = new Handler(apiUrl, this.serializer);
        this.chainID = "";
        this.txSigner = null;
        this.companyBcid = "";
    }

    public TxStatus sendCertificateRawV1(String uuid, byte[] value) throws ApiException, IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, ClientException {
        CertificateRawV1 certificate = new CertificateRawV1(Common.formatTxid(this.companyBcid, uuid), value);
        return this.sendTx(certificate);
    }

    public TxStatus sendCertificateEd25519V1(String uuid, PublicKey signer, byte[] signature) throws ApiException, IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, ClientException {
        CertificateEd25519V1 certificate = new CertificateEd25519V1(Common.formatTxid(this.companyBcid, uuid), signature, signer);
        return this.sendTx(certificate);
    }

    public TxStatus sendKeyCreateV1(String uuid, PublicKey publicKey, String role) throws ApiException, IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, ClientException {
        KeyCreateV1 keyCreate = new KeyCreateV1(Common.formatTxid(this.companyBcid, uuid), publicKey, role);
        return this.sendTx(keyCreate);
    }

    public TxStatus sendKeyRevokeV1(String uuid, PublicKey publicKey) throws ApiException, IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, ClientException {
        KeyRevokeV1 keyRevoke = new KeyRevokeV1(Common.formatTxid(this.companyBcid, uuid), publicKey);
        return this.sendTx(keyRevoke);
    }

    public TxStatus sendSecretNaclBoxV1(String uuid, com.github.katenachain.crypto.Nacl.PublicKey sender, byte[] nonce, byte[] content) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, IOException, ApiException, ClientException {
        SecretNaclBoxV1 secret = new SecretNaclBoxV1(content, Common.formatTxid(this.companyBcid, uuid), nonce, sender);
        return this.sendTx(secret);
    }

    public TxStatus sendTx(TxData txData) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, IOException, ApiException, ClientException {
        if (this.txSigner == null || this.chainID.equals("")) {
            throw new ClientException("impossible to create txs without a private key or chain id");
        }
        Tx tx = this.apiHandler.signTx(this.txSigner, this.chainID, new Date(), txData);
        return this.apiHandler.sendTx(tx);
    }

    public TxWrapper retrieveLastCertificate(String companyBcid, String uuid) throws IOException, ApiException {
        return this.apiHandler.retrieveLastCertificate(Common.formatTxid(companyBcid, uuid));
    }

    public TxWrappers retrieveCertificates(String companyBcid, String uuid, int page, int txPerPage) throws IOException, ApiException {
        return this.apiHandler.retrieveCertificates(Common.formatTxid(companyBcid, uuid), page, txPerPage);
    }

    public TxWrappers retrieveKeyCreateTxs(String companyBcid, String uuid, int page, int txPerPage) throws IOException, ApiException {
        return this.apiHandler.retrieveTxs(Account.getCategoryKeyCreate(), Common.formatTxid(companyBcid, uuid), page, txPerPage);
    }

    public TxWrappers retrieveKeyRevokeTxs(String companyBcid, String uuid, int page, int txPerPage) throws IOException, ApiException {
        return this.apiHandler.retrieveTxs(Account.getCategoryKeyRevoke(), Common.formatTxid(companyBcid, uuid), page, txPerPage);
    }

    public KeyV1[] retrieveCompanyKeys(String companyBcid, int page, int txPerPage) throws IOException, ApiException {
        return this.apiHandler.retrieveCompanyKeys(companyBcid, page, txPerPage);
    }

    public TxWrappers retrieveSecrets(String companyBcid, String uuid, int page, int txPerPage) throws IOException, ApiException {
        return this.apiHandler.retrieveSecrets(Common.formatTxid(companyBcid, uuid), page, txPerPage);
    }

    public TxWrappers retrieveTxs(String txCategory, String companyBcid, String uuid, int page, int txPerPage) throws IOException, ApiException {
        return this.apiHandler.retrieveTxs(txCategory, Common.formatTxid(companyBcid, uuid), page, txPerPage);
    }
}

