/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain.api;

import com.github.katenachain.entity.api.RawResponse;
import com.github.katenachain.utils.Common;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Client {
    private final OkHttpClient okHttpClient;
    private String apiUrl;

    public Client(String apiUrl) {
        this.apiUrl = apiUrl;
        this.okHttpClient = new OkHttpClient();
    }

    public RawResponse get(String route) throws IOException {
        return this.doRequest("GET", route, null, new HashMap<String, String>());
    }

    public RawResponse get(String route, HashMap<String, String> queryValues) throws IOException {
        return this.doRequest("GET", route, null, queryValues);
    }

    public RawResponse post(String route, byte[] body) throws IOException {
        return this.doRequest("POST", route, body, new HashMap<String, String>());
    }

    public RawResponse post(String route, byte[] body, HashMap<String, String> queryValues) throws IOException {
        return this.doRequest("POST", route, body, queryValues);
    }

    private RawResponse doRequest(String method, String route, byte[] body, HashMap<String, String> queryValues) throws IOException {
        HttpUrl httpUrl = Common.getUri(this.apiUrl, new String[]{route}, queryValues);
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(httpUrl);
        if (body != null) {
            RequestBody requestBody = RequestBody.create(null, (byte[])body);
            requestBuilder.method(method, requestBody);
        } else {
            requestBuilder.method(method, null);
        }
        OkHttpClient requestClient = this.okHttpClient.newBuilder().protocols((List)new ArrayList<Protocol>(){
            {
                this.add(Protocol.HTTP_1_1);
            }
        }).build();
        Response response = requestClient.newCall(requestBuilder.build()).execute();
        byte[] responseBody = response.body() != null ? response.body().bytes() : null;
        return new RawResponse(response.code(), responseBody);
    }
}

