/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain.api;

import com.github.katenachain.api.Client;
import com.github.katenachain.crypto.ED25519.PrivateKey;
import com.github.katenachain.entity.Tx;
import com.github.katenachain.entity.TxData;
import com.github.katenachain.entity.TxDataState;
import com.github.katenachain.entity.account.KeyV1;
import com.github.katenachain.entity.api.RawResponse;
import com.github.katenachain.entity.api.TxStatus;
import com.github.katenachain.entity.api.TxWrapper;
import com.github.katenachain.entity.api.TxWrappers;
import com.github.katenachain.exceptions.ApiException;
import com.github.katenachain.serializer.Serializer;
import com.github.katenachain.utils.Common;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Date;
import java.util.HashMap;

public class Handler {
    private static final String CERTIFICATES_PATH = "certificates";
    private static final String SECRETS_PATH = "secrets";
    private static final String LAST_PATH = "last";
    private static final String TXS_PATH = "txs";
    private static final String COMPANIES_PATH = "companies";
    private static final String KEYS_PATH = "keys";
    private Client apiClient;
    private Serializer serializer;

    public Handler(String apiUrl, Serializer serializer) {
        this.apiClient = new Client(apiUrl);
        this.serializer = serializer;
    }

    public TxStatus sendTx(Tx tx) throws IOException, ApiException {
        RawResponse apiResponse = this.apiClient.post(TXS_PATH, this.serializer.serialize(tx).getBytes());
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 202) {
            return (TxStatus)this.serializer.deserialize(jsonBody, TxStatus.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public TxWrapper retrieveLastCertificate(String id) throws IOException, ApiException {
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s/%s", CERTIFICATES_PATH, id, LAST_PATH));
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (TxWrapper)this.serializer.deserialize(jsonBody, TxWrapper.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public TxWrappers retrieveCertificates(String id, int page, int txPerPage) throws IOException, ApiException {
        HashMap<String, String> queryParams = Common.getPaginationQueryParams(page, txPerPage);
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s", CERTIFICATES_PATH, id), queryParams);
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (TxWrappers)this.serializer.deserialize(jsonBody, TxWrappers.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public TxWrappers retrieveSecrets(String id, int page, int txPerPage) throws IOException, ApiException {
        HashMap<String, String> queryParams = Common.getPaginationQueryParams(page, txPerPage);
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s", SECRETS_PATH, id), queryParams);
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (TxWrappers)this.serializer.deserialize(jsonBody, TxWrappers.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public TxWrappers retrieveTxs(String txCategory, String id, int page, int txPerPage) throws IOException, ApiException {
        HashMap<String, String> queryParams = Common.getPaginationQueryParams(page, txPerPage);
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s/%s", TXS_PATH, txCategory, id), queryParams);
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (TxWrappers)this.serializer.deserialize(jsonBody, TxWrappers.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public KeyV1[] retrieveCompanyKeys(String companyBcid, int page, int txPerPage) throws IOException, ApiException {
        HashMap<String, String> queryParams = Common.getPaginationQueryParams(page, txPerPage);
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s/%s", COMPANIES_PATH, companyBcid, KEYS_PATH), queryParams);
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (KeyV1[])this.serializer.deserialize(jsonBody, KeyV1[].class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public Tx signTx(PrivateKey privateKey, String chainID, Date nonceTime, TxData txData) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        byte[] txDataState = this.getTxDataState(chainID, nonceTime, txData);
        byte[] signature = privateKey.sign(txDataState);
        return new Tx(txData, nonceTime, signature, privateKey.getPublicKey());
    }

    public byte[] getTxDataState(String chainID, Date nonceTime, TxData txData) {
        return this.serializer.serialize(new TxDataState(chainID, nonceTime, txData)).getBytes();
    }
}

