/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain.crypto.ED25519;

import com.github.katenachain.crypto.AbstractKey;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public class PublicKey
extends AbstractKey {
    private EdDSANamedCurveSpec ed25519 = EdDSANamedCurveTable.getByName((String)"Ed25519");

    public PublicKey(byte[] key) {
        super(key);
    }

    public boolean verify(byte[] message, byte[] signature) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        EdDSAEngine engine = new EdDSAEngine(MessageDigest.getInstance(this.ed25519.getHashAlgorithm()));
        EdDSAPublicKeySpec spec = new EdDSAPublicKeySpec(this.key, (EdDSAParameterSpec)EdDSANamedCurveTable.getByName((String)this.ed25519.getHashAlgorithm()));
        EdDSAPublicKey pKey = new EdDSAPublicKey(spec);
        engine.initVerify((java.security.PublicKey)pKey);
        engine.update(message);
        return engine.verify(signature);
    }
}

