/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain;

import com.github.katenachain.api.Handler;
import com.github.katenachain.crypto.ED25519.PublicKey;
import com.github.katenachain.entity.Tx;
import com.github.katenachain.entity.TxData;
import com.github.katenachain.entity.TxSigner;
import com.github.katenachain.entity.account.KeyCreateV1;
import com.github.katenachain.entity.account.KeyRevokeV1;
import com.github.katenachain.entity.account.KeyRotateV1;
import com.github.katenachain.entity.account.KeyV1;
import com.github.katenachain.entity.api.SendTxResult;
import com.github.katenachain.entity.api.TxResult;
import com.github.katenachain.entity.api.TxResults;
import com.github.katenachain.entity.certify.CertificateEd25519V1;
import com.github.katenachain.entity.certify.CertificateRawV1;
import com.github.katenachain.entity.certify.SecretNaclBoxV1;
import com.github.katenachain.exceptions.ApiException;
import com.github.katenachain.exceptions.ClientException;
import com.github.katenachain.serializer.Serializer;
import com.github.katenachain.utils.Common;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.time.Instant;

public class Transactor {
    private Handler apiHandler;
    private String chainId;
    private TxSigner txSigner;
    private Serializer serializer = new Serializer(new GsonBuilder());

    public Transactor(String apiUrl, String chainId, TxSigner txSigner) {
        this.apiHandler = new Handler(apiUrl, this.serializer);
        this.chainId = chainId;
        this.txSigner = txSigner;
    }

    public Transactor(String apiUrl) {
        this.apiHandler = new Handler(apiUrl, this.serializer);
        this.chainId = "";
        this.txSigner = null;
    }

    public SendTxResult sendCertificateRawV1Tx(String id, byte[] value) throws ApiException, IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, ClientException {
        CertificateRawV1 certificate = new CertificateRawV1(id, value);
        return this.sendTx(certificate);
    }

    public SendTxResult sendCertificateEd25519V1Tx(String id, PublicKey signer, byte[] signature) throws ApiException, IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, ClientException {
        CertificateEd25519V1 certificate = new CertificateEd25519V1(id, signer, signature);
        return this.sendTx(certificate);
    }

    public SendTxResult sendSecretNaclBoxV1Tx(String id, com.github.katenachain.crypto.Nacl.PublicKey sender, byte[] nonce, byte[] content) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, IOException, ApiException, ClientException {
        SecretNaclBoxV1 secret = new SecretNaclBoxV1(content, id, nonce, sender);
        return this.sendTx(secret);
    }

    public SendTxResult sendKeyCreateV1Tx(String id, PublicKey publicKey, String role) throws ApiException, IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, ClientException {
        KeyCreateV1 keyCreate = new KeyCreateV1(id, publicKey, role);
        return this.sendTx(keyCreate);
    }

    public SendTxResult sendKeyRotateV1Tx(String id, PublicKey publicKey) throws ApiException, IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, ClientException {
        KeyRotateV1 keyRotate = new KeyRotateV1(id, publicKey);
        return this.sendTx(keyRotate);
    }

    public SendTxResult sendKeyRevokeV1Tx(String id) throws ApiException, IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, ClientException {
        KeyRevokeV1 keyRevoke = new KeyRevokeV1(id);
        return this.sendTx(keyRevoke);
    }

    public SendTxResult sendTx(TxData txData) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, IOException, ApiException, ClientException {
        if (this.txSigner == null || this.txSigner.getFqId().equals("") || this.txSigner.getPrivateKey() == null || this.chainId.equals("")) {
            throw new ClientException("impossible to create txs without a tx signer info or chain id");
        }
        Tx tx = this.apiHandler.signTx(this.txSigner, this.chainId, Instant.now(), txData);
        return this.apiHandler.sendTx(tx);
    }

    public TxResult retrieveLastCertificateTx(String companyBcId, String id) throws IOException, ApiException {
        return this.apiHandler.retrieveLastCertificateTx(Common.concatFqId(companyBcId, id));
    }

    public TxResults retrieveCertificateTxs(String companyBcId, String id, int page, int txPerPage) throws IOException, ApiException {
        return this.apiHandler.retrieveCertificateTxs(Common.concatFqId(companyBcId, id), page, txPerPage);
    }

    public TxResult retrieveLastSecretTx(String companyBcId, String id) throws IOException, ApiException {
        return this.apiHandler.retrieveLastSecretTx(Common.concatFqId(companyBcId, id));
    }

    public TxResults retrieveSecretTxs(String companyBcId, String id, int page, int txPerPage) throws IOException, ApiException {
        return this.apiHandler.retrieveSecretTxs(Common.concatFqId(companyBcId, id), page, txPerPage);
    }

    public TxResult retrieveLastKeyTx(String companyBcId, String id) throws IOException, ApiException {
        return this.apiHandler.retrieveLastKeyTx(Common.concatFqId(companyBcId, id));
    }

    public TxResults retrieveKeyTxs(String companyBcId, String id, int page, int txPerPage) throws IOException, ApiException {
        return this.apiHandler.retrieveKeyTxs(Common.concatFqId(companyBcId, id), page, txPerPage);
    }

    public TxResult retrieveTx(String hash) throws IOException, ApiException {
        return this.apiHandler.retrieveTx(hash);
    }

    public TxData retrieveCertificate(String companyBcId, String id) throws IOException, ApiException {
        return this.apiHandler.retrieveCertificate(Common.concatFqId(companyBcId, id));
    }

    public TxData retrieveSecret(String companyBcId, String id) throws IOException, ApiException {
        return this.apiHandler.retrieveSecret(Common.concatFqId(companyBcId, id));
    }

    public KeyV1 retrieveKey(String companyBcId, String id) throws IOException, ApiException {
        return this.apiHandler.retrieveKey(Common.concatFqId(companyBcId, id));
    }

    public KeyV1[] retrieveCompanyKeys(String companyBcId, int page, int txPerPage) throws IOException, ApiException {
        return this.apiHandler.retrieveCompanyKeys(companyBcId, page, txPerPage);
    }
}

