/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain.api;

import com.github.katenachain.api.Client;
import com.github.katenachain.entity.Tx;
import com.github.katenachain.entity.TxData;
import com.github.katenachain.entity.TxDataState;
import com.github.katenachain.entity.TxSigner;
import com.github.katenachain.entity.account.KeyV1;
import com.github.katenachain.entity.api.RawResponse;
import com.github.katenachain.entity.api.SendTxResult;
import com.github.katenachain.entity.api.TxResult;
import com.github.katenachain.entity.api.TxResults;
import com.github.katenachain.exceptions.ApiException;
import com.github.katenachain.serializer.Serializer;
import com.github.katenachain.utils.Common;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.time.Instant;
import java.util.HashMap;

public class Handler {
    private static final String LAST_PATH = "last";
    private static final String STATE_PATH = "state";
    private static final String TXS_PATH = "txs";
    private static final String CERTIFICATES_PATH = "certificates";
    private static final String SECRETS_PATH = "secrets";
    private static final String COMPANIES_PATH = "companies";
    private static final String KEYS_PATH = "keys";
    private Client apiClient;
    private Serializer serializer;

    public Handler(String apiUrl, Serializer serializer) {
        this.apiClient = new Client(apiUrl);
        this.serializer = serializer;
    }

    public TxResult retrieveLastCertificateTx(String fqId) throws IOException, ApiException {
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s/%s", CERTIFICATES_PATH, fqId, LAST_PATH));
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (TxResult)this.serializer.deserialize(jsonBody, TxResult.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public TxResults retrieveCertificateTxs(String fqId, int page, int txPerPage) throws IOException, ApiException {
        HashMap<String, String> queryParams = Common.getPaginationQueryParams(page, txPerPage);
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s", CERTIFICATES_PATH, fqId), queryParams);
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (TxResults)this.serializer.deserialize(jsonBody, TxResults.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public TxResult retrieveLastSecretTx(String fqId) throws IOException, ApiException {
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s/%s", SECRETS_PATH, fqId, LAST_PATH));
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (TxResult)this.serializer.deserialize(jsonBody, TxResult.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public TxResults retrieveSecretTxs(String fqId, int page, int txPerPage) throws IOException, ApiException {
        HashMap<String, String> queryParams = Common.getPaginationQueryParams(page, txPerPage);
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s", SECRETS_PATH, fqId), queryParams);
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (TxResults)this.serializer.deserialize(jsonBody, TxResults.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public TxResult retrieveLastKeyTx(String fqId) throws IOException, ApiException {
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s/%s", KEYS_PATH, fqId, LAST_PATH));
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (TxResult)this.serializer.deserialize(jsonBody, TxResult.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public TxResults retrieveKeyTxs(String fqId, int page, int txPerPage) throws IOException, ApiException {
        HashMap<String, String> queryParams = Common.getPaginationQueryParams(page, txPerPage);
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s", KEYS_PATH, fqId), queryParams);
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (TxResults)this.serializer.deserialize(jsonBody, TxResults.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public TxResult retrieveTx(String hash) throws IOException, ApiException {
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s", TXS_PATH, hash));
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (TxResult)this.serializer.deserialize(jsonBody, TxResult.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public TxData retrieveCertificate(String fqId) throws IOException, ApiException {
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s/%s", STATE_PATH, CERTIFICATES_PATH, fqId));
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (TxData)this.serializer.deserialize(jsonBody, TxData.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public TxData retrieveSecret(String fqId) throws IOException, ApiException {
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s/%s", STATE_PATH, SECRETS_PATH, fqId));
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (TxData)this.serializer.deserialize(jsonBody, TxData.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public KeyV1 retrieveKey(String fqId) throws IOException, ApiException {
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s/%s", STATE_PATH, KEYS_PATH, fqId));
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (KeyV1)this.serializer.deserialize(jsonBody, KeyV1.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public KeyV1[] retrieveCompanyKeys(String companyBcId, int page, int txPerPage) throws IOException, ApiException {
        HashMap<String, String> queryParams = Common.getPaginationQueryParams(page, txPerPage);
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s/%s/%s", STATE_PATH, COMPANIES_PATH, companyBcId, KEYS_PATH), queryParams);
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (KeyV1[])this.serializer.deserialize(jsonBody, KeyV1[].class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public SendTxResult sendTx(Tx tx) throws IOException, ApiException {
        RawResponse apiResponse = this.apiClient.post(TXS_PATH, this.serializer.serialize(tx).getBytes());
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 202) {
            return (SendTxResult)this.serializer.deserialize(jsonBody, SendTxResult.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public Tx signTx(TxSigner txSigner, String chainId, Instant nonceTime, TxData txData) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        byte[] txDataState = this.getTxDataState(chainId, nonceTime, txData);
        byte[] signature = txSigner.getPrivateKey().sign(txDataState);
        return new Tx(txData, nonceTime, signature, txSigner.getFqId());
    }

    public byte[] getTxDataState(String chainId, Instant nonceTime, TxData txData) {
        return this.serializer.serialize(new TxDataState(chainId, nonceTime, txData)).getBytes();
    }
}

