/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain.entity.certify;

import com.github.katenachain.crypto.Nacl.PublicKey;
import com.github.katenachain.entity.TxData;
import com.github.katenachain.entity.certify.Certify;
import com.github.katenachain.utils.Common;
import java.util.HashMap;

public class SecretNaclBoxV1
implements TxData {
    private byte[] content;
    private String id;
    private byte[] nonce;
    private PublicKey sender;

    public SecretNaclBoxV1(byte[] content, String id, byte[] nonce, PublicKey sender) {
        this.content = content;
        this.id = id;
        this.nonce = nonce;
        this.sender = sender;
    }

    public String getId() {
        return this.id;
    }

    public PublicKey getSender() {
        return this.sender;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public byte[] getContent() {
        return this.content;
    }

    @Override
    public String getType() {
        return Certify.getSecretNaclBoxV1Type();
    }

    @Override
    public String getNamespace() {
        return "certify";
    }

    @Override
    public HashMap<String, String> getStateIds(final String signerCompanyBcId) {
        final String id = this.id;
        return new HashMap<String, String>(){
            {
                this.put(Certify.getSecretIdKey(), Common.concatFqId(signerCompanyBcId, id));
            }
        };
    }
}

