/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain.serializer;

import com.github.katenachain.crypto.AbstractKey;
import com.github.katenachain.entity.TxData;
import com.github.katenachain.serializer.adapter.BytesSerializer;
import com.github.katenachain.serializer.adapter.CryptoSerializer;
import com.github.katenachain.serializer.adapter.InstantSerializer;
import com.github.katenachain.serializer.adapter.TxDataSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.time.Instant;

public class Serializer {
    private Gson serializer;

    public Serializer(GsonBuilder gsonBuilder) {
        gsonBuilder.serializeNulls();
        gsonBuilder.registerTypeAdapter(TxData.class, (Object)new TxDataSerializer());
        gsonBuilder.registerTypeHierarchyAdapter(AbstractKey.class, (Object)new CryptoSerializer());
        gsonBuilder.registerTypeAdapter(Instant.class, (Object)new InstantSerializer()).create();
        gsonBuilder.registerTypeAdapter(byte[].class, (Object)new BytesSerializer()).create();
        gsonBuilder.disableHtmlEscaping();
        this.serializer = gsonBuilder.create();
    }

    public String serialize(Object object) {
        return this.serializer.toJson(object);
    }

    public String serialize(Object object, Type typeOfSrc) {
        return this.serializer.toJson(object, typeOfSrc);
    }

    public Object deserialize(String content, Class clazz) {
        return this.serializer.fromJson(content, clazz);
    }
}

