/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain.utils;

import com.github.katenachain.crypto.ED25519.PrivateKey;
import com.github.katenachain.crypto.Nacl.PublicKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Base64;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.KeyPairGenerator;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;

public class Crypto {
    public static PrivateKey createPrivateKeyEd25519FromBase64(String privateKeyBase64) {
        return new PrivateKey(Base64.getDecoder().decode(privateKeyBase64));
    }

    public static com.github.katenachain.crypto.ED25519.PublicKey createPublicKeyEd25519FromBase64(String publicKeyBase64) {
        return new com.github.katenachain.crypto.ED25519.PublicKey(Base64.getDecoder().decode(publicKeyBase64));
    }

    public static PrivateKey generateNewPrivateKeyEd25519() throws InvalidAlgorithmParameterException, IOException {
        KeyPairGenerator keyPairGenerator = new KeyPairGenerator();
        keyPairGenerator.initialize((AlgorithmParameterSpec)EdDSANamedCurveTable.getByName((String)"Ed25519"), new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        EdDSAPrivateKey privateKey = (EdDSAPrivateKey)keyPair.getPrivate();
        EdDSAPublicKey publicKey = (EdDSAPublicKey)keyPair.getPublic();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(privateKey.getSeed());
        outputStream.write(publicKey.getAbyte());
        return new PrivateKey(outputStream.toByteArray());
    }

    public static com.github.katenachain.crypto.Nacl.PrivateKey createPrivateKeyX25519FromBase64(String privateKeyBase64) {
        return new com.github.katenachain.crypto.Nacl.PrivateKey(Base64.getDecoder().decode(privateKeyBase64));
    }

    public static PublicKey createPublicKeyX25519FromBase64(String publicKeyBase64) {
        return new PublicKey(Base64.getDecoder().decode(publicKeyBase64));
    }
}

