/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain.entity.account;

import com.github.katenachain.crypto.ED25519.PublicKey;
import com.github.katenachain.entity.TxData;
import com.github.katenachain.entity.account.Account;
import com.github.katenachain.utils.Common;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;

public class KeyCreateV1
implements TxData {
    private String id;
    @SerializedName(value="public_key")
    private PublicKey publicKey;
    private String role;

    public KeyCreateV1(String id, PublicKey publicKey, String role) {
        this.id = id;
        this.publicKey = publicKey;
        this.role = role;
    }

    public String getId() {
        return this.id;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getRole() {
        return this.role;
    }

    @Override
    public String getType() {
        return Account.getKeyCreateV1Type();
    }

    @Override
    public String getNamespace() {
        return "account";
    }

    @Override
    public HashMap<String, String> getStateIds(final String signerCompanyBcId) {
        final String id = this.id;
        return new HashMap<String, String>(){
            {
                this.put(Account.getKeyIdKey(), Common.concatFqId(signerCompanyBcId, id));
            }
        };
    }
}

