/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain.entity.certify;

import com.github.katenachain.crypto.ED25519.PublicKey;
import com.github.katenachain.entity.TxData;
import com.github.katenachain.entity.certify.Certify;
import com.github.katenachain.utils.Common;
import java.util.HashMap;

public class CertificateEd25519V1
implements TxData {
    private String id;
    private byte[] signature;
    private PublicKey signer;

    public CertificateEd25519V1(String id, PublicKey signer, byte[] signature) {
        this.id = id;
        this.signature = signature;
        this.signer = signer;
    }

    public String getId() {
        return this.id;
    }

    public PublicKey getSigner() {
        return this.signer;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public String getType() {
        return Certify.getCertificateEd25519V1Type();
    }

    @Override
    public String getNamespace() {
        return "certify";
    }

    @Override
    public HashMap<String, String> getStateIds(final String signerCompanyBcId) {
        final String id = this.id;
        return new HashMap<String, String>(){
            {
                this.put(Certify.getCertificateIdKey(), Common.concatFqId(signerCompanyBcId, id));
            }
        };
    }
}

