/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain.serializer.adapter;

import com.github.katenachain.entity.TxData;
import com.github.katenachain.entity.UnknownTxData;
import com.github.katenachain.entity.account.Account;
import com.github.katenachain.entity.account.KeyCreateV1;
import com.github.katenachain.entity.account.KeyRevokeV1;
import com.github.katenachain.entity.account.KeyRotateV1;
import com.github.katenachain.entity.certify.CertificateEd25519V1;
import com.github.katenachain.entity.certify.CertificateRawV1;
import com.github.katenachain.entity.certify.Certify;
import com.github.katenachain.entity.certify.SecretNaclBoxV1;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;

public class TxDataSerializer
implements JsonSerializer<TxData>,
JsonDeserializer<TxData> {
    public static HashMap<String, Class> getAvailableTypes() {
        return new HashMap<String, Class>(){
            {
                this.put(Certify.getCertificateEd25519V1Type(), CertificateEd25519V1.class);
                this.put(Certify.getCertificateRawV1Type(), CertificateRawV1.class);
                this.put(Certify.getSecretNaclBoxV1Type(), SecretNaclBoxV1.class);
                this.put(Account.getKeyCreateV1Type(), KeyCreateV1.class);
                this.put(Account.getKeyRotateV1Type(), KeyRotateV1.class);
                this.put(Account.getKeyRevokeV1Type(), KeyRevokeV1.class);
            }
        };
    }

    public synchronized JsonElement serialize(TxData txData, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonElement value = jsonSerializationContext.serialize((Object)txData);
        if (txData instanceof UnknownTxData) {
            return value;
        }
        JsonObject txDataJsonObject = new JsonObject();
        txDataJsonObject.add("type", (JsonElement)new JsonPrimitive(txData.getType()));
        txDataJsonObject.add("value", value);
        return txDataJsonObject;
    }

    public synchronized TxData deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement.getAsJsonObject().has("type") && TxDataSerializer.getAvailableTypes().containsKey(jsonElement.getAsJsonObject().get("type").getAsString())) {
            return (TxData)jsonDeserializationContext.deserialize(jsonElement.getAsJsonObject().get("value"), (Type)TxDataSerializer.getAvailableTypes().get(jsonElement.getAsJsonObject().get("type").getAsString()));
        }
        return (TxData)jsonDeserializationContext.deserialize((JsonElement)jsonElement.getAsJsonObject(), UnknownTxData.class);
    }
}

