/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain.utils;

import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;

public class Common {
    private static final String PAGE_PARAM = "page";
    private static final String PER_PAGE_PARAM = "per_page";
    public static final int DEFAULT_PER_PAGE_PARAM = 10;

    public static HttpUrl getUri(String basePath, String[] paths, HashMap<String, String> queryValues) {
        HttpUrl url = HttpUrl.get((String)basePath);
        HttpUrl.Builder builder = url.newBuilder();
        if (paths != null) {
            for (String path : paths) {
                builder.addPathSegments(path);
            }
        }
        if (queryValues != null) {
            for (Map.Entry entry : queryValues.entrySet()) {
                builder.addQueryParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return builder.build();
    }

    public static String concatFqId(String companyBcId, String uuid) {
        return String.format("%s-%s", companyBcId, uuid);
    }

    public static HashMap<String, String> getPaginationQueryParams(final int page, final int perPage) {
        return new HashMap<String, String>(){
            {
                this.put(Common.PAGE_PARAM, String.valueOf(page));
                this.put(Common.PER_PAGE_PARAM, String.valueOf(perPage));
            }
        };
    }
}

