/*
 * Decompiled with CFR 0.152.
 */
package com.github.kevinstl.coinbase.java.client;

import com.github.kevinstl.coinbase.java.client.CoinbaseHttpClient;
import com.github.kevinstl.coinbase.java.client.authentication.AuthenticationHeaderAppender;
import com.github.kevinstl.coinbase.java.exception.CoinbaseException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CoinbaseAuthenticatedHttpClient
extends CoinbaseHttpClient {
    private static Logger logger = Logger.getLogger(CoinbaseAuthenticatedHttpClient.class.getName());
    private HttpClient coinbaseApacheHttpClient;
    private AuthenticationHeaderAppender authenticationHeaderAppender;

    @Autowired
    public CoinbaseAuthenticatedHttpClient(HttpClient coinbaseApacheHttpClient, AuthenticationHeaderAppender authenticationHeaderAppender) {
        super(coinbaseApacheHttpClient);
        this.coinbaseApacheHttpClient = coinbaseApacheHttpClient;
        this.authenticationHeaderAppender = authenticationHeaderAppender;
    }

    @Override
    protected String executeHttpUriRequest(HttpUriRequest httpUriRequest, String urlString, String payload, String contentType) throws IOException, ClientProtocolException {
        try {
            this.authenticationHeaderAppender.append(httpUriRequest, urlString, payload);
        }
        catch (InvalidKeyException e) {
            throw new CoinbaseException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CoinbaseException(e.getMessage());
        }
        return super.executeHttpUriRequest(httpUriRequest, urlString, payload, contentType);
    }
}

