/*
 * Decompiled with CFR 0.152.
 */
package com.github.kevinstl.coinbase.java.client;

import com.github.kevinstl.coinbase.java.client.CoinbaseAuthenticatedHttpClient;
import com.github.kevinstl.coinbase.java.domain.deserializer.ResponseDeserializer;
import com.github.kevinstl.coinbase.java.domain.request.ButtonRequest;
import com.github.kevinstl.coinbase.java.domain.request.BuyRequest;
import com.github.kevinstl.coinbase.java.domain.request.OauthApplication;
import com.github.kevinstl.coinbase.java.domain.request.TokenRequest;
import com.github.kevinstl.coinbase.java.domain.request.TransactionFromRequest;
import com.github.kevinstl.coinbase.java.domain.request.TransactionRequest;
import com.github.kevinstl.coinbase.java.domain.request.UserRequest;
import com.github.kevinstl.coinbase.java.domain.response.BuyResponse;
import com.github.kevinstl.coinbase.java.domain.response.ExchangeRatesResponse;
import com.github.kevinstl.coinbase.java.domain.response.SendMoneyResponse;
import com.github.kevinstl.coinbase.java.exception.CoinbaseException;
import com.google.gson.Gson;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.logging.Logger;
import org.apache.http.client.ClientProtocolException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CoinbaseClient {
    private static final String INVALID_TOKEN = "invalid_token";
    public static final String INVALID_API_KEY = "Invalid api_key";
    public static final String FORWARD_SLASH = "/";
    public static final String ACCOUNT_CHANGES = "/account_changes";
    public static final String GENERATE_RECEIVE_ADDRESS = "/account/generate_receive_address";
    public static final String BALANCE = "/account/balance";
    public static final String RECEIVE_ADDRESS = "/account/receive_address";
    public static final String ADDRESSES = "/addresses";
    public static final String OAUTH = "/oauth";
    public static final String OAUTH_APPLICATIONS = "/oauth/applications";
    public static final String AUTHORIZATION = "/authorization";
    private static final String BUTTONS = "/buttons";
    private static final String CREATE_ORDER = "/create_order";
    public static final String BUYS = "/buys";
    public static final String CONTACTS = "/contacts";
    public static final String CURRENCIES = "/currencies";
    public static final String EXCHANGE_RATES = "/exchange_rates";
    public static final String ORDERS = "/orders";
    public static final String PAYMENT_METHODS = "/payment_methods";
    public static final String PRICES_BUY = "/prices/buy";
    public static final String PRICES_SELL = "/prices/sell";
    public static final String PRICES_SPOT_RATE = "/prices/spot_rate";
    public static final String PRICES_HISTORICAL = "/prices/historical";
    private static final String RECURRING_PAYMENTS = "/recurring_payments";
    private static final String SUBSCRIBERS = "/subscribers";
    public static final String TOKENS = "/tokens";
    public static final String TRANSACTIONS = "/transactions";
    public static final String SEND_MONEY = "send_money";
    public static final String REQUEST_MONEY = "request_money";
    public static final String RESEND_REQUEST = "resend_request";
    public static final String CANCEL_REQUEST = "cancel_request";
    public static final String COMPLETE_REQUEST = "complete_request";
    public static final String TRANSFERS = "/transfers";
    public static final String USERS = "/users";
    private static final String HTTPS_COINBASE_COM_API_V1_ACCOUNT = "https://coinbase.com/api/v1";
    private static Logger logger = Logger.getLogger(CoinbaseClient.class.getName());
    @Autowired
    private CoinbaseAuthenticatedHttpClient coinbaseAuthenticatedHttpClient;
    @Autowired
    private ResponseDeserializer responseDeserializer;

    public CoinbaseAuthenticatedHttpClient getCoinbaseAuthenticatedHttpClient() {
        return this.coinbaseAuthenticatedHttpClient;
    }

    public void setCoinbaseAuthenticatedHttpClient(CoinbaseAuthenticatedHttpClient coinbaseAuthenticatedHttpClient) {
        this.coinbaseAuthenticatedHttpClient = coinbaseAuthenticatedHttpClient;
    }

    public ResponseDeserializer getResponseDeserializer() {
        return this.responseDeserializer;
    }

    public void setResponseDeserializer(ResponseDeserializer responseDeserializer) {
        this.responseDeserializer = responseDeserializer;
    }

    public String getAccountChanges() throws ClientProtocolException, IOException {
        String operation = ACCOUNT_CHANGES;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String getBalance() throws ClientProtocolException, IOException {
        String operation = BALANCE;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String getReceiveAddress() throws ClientProtocolException, IOException {
        String operation = RECEIVE_ADDRESS;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String getAddresses() throws ClientProtocolException, IOException {
        String operation = ADDRESSES;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String getOauthApplications() throws ClientProtocolException, IOException {
        String operation = OAUTH_APPLICATIONS;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String getOauthIndividualApplication(Integer applicationId) throws ClientProtocolException, IOException {
        String operation = "/oauth/applications/" + applicationId;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String postCreateOauthApplication(OauthApplication oauthApplication) throws ClientProtocolException, IOException {
        String operation = OAUTH_APPLICATIONS;
        Gson gson = new Gson();
        String payload = gson.toJson((Object)oauthApplication);
        String responseString = this.httpPost(operation, payload);
        return responseString;
    }

    public String getAuthorization() throws ClientProtocolException, IOException {
        String operation = AUTHORIZATION;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String postCreatePaymentObject(ButtonRequest buttonRequest) throws ClientProtocolException, IOException {
        String operation = BUTTONS;
        Gson gson = new Gson();
        String payload = gson.toJson((Object)buttonRequest);
        String responseString = this.httpPost(operation, payload);
        return responseString;
    }

    public String postCreateOrder(String objectId) throws ClientProtocolException, IOException {
        String operation = "/buttons/" + objectId + CREATE_ORDER;
        String responseString = this.httpPost(operation, null);
        return responseString;
    }

    public String getContacts() throws ClientProtocolException, IOException {
        String operation = CONTACTS;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String getCurrencies() throws ClientProtocolException, IOException {
        String operation = CURRENCIES;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String getExchangeRates() throws ClientProtocolException, IOException {
        String operation = "/currencies/exchange_rates";
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public BigDecimal getSpecificExchangeRate(String exchangeRateType) throws ClientProtocolException, IOException {
        String exchangeRates = this.getExchangeRates();
        ExchangeRatesResponse exchangeRatesResponse = this.responseDeserializer.deserializeExchangeRatesResponse(exchangeRates);
        BigDecimal specifiedExchangeRate = (BigDecimal)exchangeRatesResponse.get(exchangeRateType);
        return specifiedExchangeRate;
    }

    public String getOrders() throws ClientProtocolException, IOException {
        String operation = ORDERS;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String postOrders(ButtonRequest buttonRequest) throws ClientProtocolException, IOException {
        String operation = BUTTONS;
        Gson gson = new Gson();
        String payload = gson.toJson((Object)buttonRequest);
        String responseString = this.httpPost(operation, payload);
        return responseString;
    }

    public String getInvidualOrder(Integer orderId) throws ClientProtocolException, IOException {
        String operation = "/orders/" + orderId;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String getPaymentMethods() throws ClientProtocolException, IOException {
        String operation = PAYMENT_METHODS;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String getPriceToBuy() throws ClientProtocolException, IOException {
        String operation = PRICES_BUY;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String getPriceToSell() throws ClientProtocolException, IOException {
        String operation = PRICES_SELL;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String getPricesSpotRate() throws ClientProtocolException, IOException {
        String operation = PRICES_SPOT_RATE;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String getPricesHistorical() throws ClientProtocolException, IOException {
        String operation = PRICES_HISTORICAL;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String getRecurringPayments() throws ClientProtocolException, IOException {
        String operation = RECURRING_PAYMENTS;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String getIndividualRecurringPayment(Integer paymentId) throws ClientProtocolException, IOException {
        String operation = "/recurring_payments/" + paymentId;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String getSubscribers() throws ClientProtocolException, IOException {
        String operation = SUBSCRIBERS;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String getIndividualSubscriber(Integer subscriberId) throws ClientProtocolException, IOException {
        String operation = "/subscribers/" + subscriberId;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String postTokens() throws ClientProtocolException, IOException {
        String operation = TOKENS;
        String responseString = this.httpPost(operation, null);
        return responseString;
    }

    public String postTokensRedeem(TokenRequest tokenRequest) throws ClientProtocolException, IOException {
        String operation = TOKENS;
        Gson gson = new Gson();
        String payload = gson.toJson((Object)tokenRequest);
        String responseString = this.httpPost(operation, payload);
        return responseString;
    }

    public String getRecentTransactions() throws ClientProtocolException, IOException {
        String operation = TRANSACTIONS;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String getIndividualTransaction(String transactionId) throws ClientProtocolException, IOException {
        String operation = "/transactions/" + transactionId;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public SendMoneyResponse sendMoney(TransactionRequest transactionSenderWrapper) throws ClientProtocolException, IOException {
        String operation = "/transactions/send_money";
        Gson gson = new Gson();
        String payload = gson.toJson((Object)transactionSenderWrapper);
        String responseString = this.httpPost(operation, payload);
        SendMoneyResponse sendMoneyResponse = this.responseDeserializer.deserializeSendMoneyResponse(responseString);
        return sendMoneyResponse;
    }

    public String postTransactionsRequestMoney(TransactionFromRequest transactionFromRequest) throws ClientProtocolException, IOException {
        String operation = "/transactions/request_money";
        Gson gson = new Gson();
        String payload = gson.toJson((Object)transactionFromRequest);
        String responseString = this.httpPost(operation, payload);
        return responseString;
    }

    public String putTransactionsResendRequest(String transactionId) throws ClientProtocolException, IOException {
        String operation = "/transactions/" + transactionId + FORWARD_SLASH + RESEND_REQUEST;
        String responseString = this.httpPut(operation, null);
        return responseString;
    }

    public String deleteTransactionsCancelRequest(String transactionId) throws ClientProtocolException, IOException {
        String operation = "/transactions/" + transactionId + FORWARD_SLASH + CANCEL_REQUEST;
        String responseString = this.httpDelete(operation);
        return responseString;
    }

    public String putTransactionsCompleteRequest(String transactionId) throws ClientProtocolException, IOException {
        String operation = "/transactions/" + transactionId + FORWARD_SLASH + COMPLETE_REQUEST;
        String responseString = this.httpPut(operation, null);
        return responseString;
    }

    public String getRecentBuysAndSells() throws ClientProtocolException, IOException {
        String operation = TRANSFERS;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String postCreateUser(UserRequest userRequest) throws ClientProtocolException, IOException {
        String operation = USERS;
        Gson gson = new Gson();
        String payload = gson.toJson((Object)userRequest);
        String responseString = this.httpPost(operation, payload);
        return responseString;
    }

    public String getCurrentUser() throws ClientProtocolException, IOException {
        String operation = USERS;
        String responseString = this.httpGet(operation);
        return responseString;
    }

    public String putUserAccountSettings(String userId, UserRequest userRequest) throws ClientProtocolException, IOException {
        String operation = "/users/" + userId;
        Gson gson = new Gson();
        String payload = gson.toJson((Object)userRequest);
        String responseString = this.httpPut(operation, payload);
        return responseString;
    }

    public String generateReceiveAddress() throws ClientProtocolException, IOException {
        String operation = GENERATE_RECEIVE_ADDRESS;
        String payload = null;
        String responseString = this.httpPost(operation, payload);
        return responseString;
    }

    public BuyResponse buy(BuyRequest buyRequest) throws ClientProtocolException, IOException {
        String operation = BUYS;
        Gson gson = new Gson();
        String payload = gson.toJson((Object)buyRequest);
        String responseString = this.httpPost(operation, payload);
        BuyResponse buyResponse = this.responseDeserializer.deserializeBuyResponse(responseString);
        return buyResponse;
    }

    public String getOperationUrl(String operation) {
        return HTTPS_COINBASE_COM_API_V1_ACCOUNT + operation;
    }

    protected String httpGet(String operation) throws IOException, ClientProtocolException {
        String urlString = this.getOperationUrl(operation);
        String responseString = this.coinbaseAuthenticatedHttpClient.executeGet(urlString);
        this.checkResponseForAuthenticationError(responseString);
        return responseString;
    }

    protected String httpPost(String operation, String payload) throws IOException, ClientProtocolException {
        String urlString = this.getOperationUrl(operation);
        String responseString = this.coinbaseAuthenticatedHttpClient.executePost(urlString, payload);
        this.checkResponseForAuthenticationError(responseString);
        return responseString;
    }

    protected String httpPut(String operation, String payload) throws IOException, ClientProtocolException {
        String urlString = this.getOperationUrl(operation);
        String responseString = this.coinbaseAuthenticatedHttpClient.executePut(urlString, payload);
        this.checkResponseForAuthenticationError(responseString);
        return responseString;
    }

    protected String httpDelete(String operation) throws IOException, ClientProtocolException {
        String urlString = this.getOperationUrl(operation);
        String responseString = this.coinbaseAuthenticatedHttpClient.executeDelete(urlString);
        this.checkResponseForAuthenticationError(responseString);
        return responseString;
    }

    protected void checkResponseForAuthenticationError(String responseString) {
        if (responseString.contains(INVALID_TOKEN) || responseString.contains(INVALID_API_KEY)) {
            throw new CoinbaseException(INVALID_API_KEY);
        }
    }
}

