/*
 * Decompiled with CFR 0.152.
 */
package com.github.kevinstl.coinbase.java.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CoinbaseHttpClient {
    private static Logger logger = Logger.getLogger(CoinbaseHttpClient.class.getName());
    private HttpClient coinbaseApacheHttpClient;

    @Autowired
    public CoinbaseHttpClient(HttpClient coinbaseApacheHttpClient) {
        this.coinbaseApacheHttpClient = coinbaseApacheHttpClient;
    }

    public String executeGet(String urlString) throws IOException, ClientProtocolException {
        HttpGet httpGet = new HttpGet(urlString);
        String responseString = this.executeHttpUriRequest((HttpUriRequest)httpGet, urlString, null, null);
        return responseString;
    }

    public String executePost(String urlString, String payload) throws IOException, ClientProtocolException {
        logger.info("payload: " + payload);
        HttpPost httpPost = new HttpPost(urlString);
        if (payload != null) {
            StringEntity stringEntity = new StringEntity(payload);
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        String responseString = this.executeHttpUriRequest((HttpUriRequest)httpPost, urlString, payload, "application/json");
        return responseString;
    }

    public String executePut(String urlString, String payload) throws IOException, ClientProtocolException {
        logger.info("payload: " + payload);
        HttpPut httpPut = new HttpPut(urlString);
        if (payload != null) {
            StringEntity stringEntity = new StringEntity(payload);
            httpPut.setEntity((HttpEntity)stringEntity);
        }
        String responseString = this.executeHttpUriRequest((HttpUriRequest)httpPut, urlString, payload, "application/json");
        return responseString;
    }

    public String executeDelete(String urlString) throws IOException, ClientProtocolException {
        HttpDelete httpDelete = new HttpDelete(urlString);
        String responseString = this.executeHttpUriRequest((HttpUriRequest)httpDelete, urlString, null, null);
        return responseString;
    }

    protected String executeHttpUriRequest(HttpUriRequest httpUriRequest, String urlString, String payload, String contentType) throws IOException, ClientProtocolException {
        if (StringUtils.isNotBlank((String)contentType)) {
            httpUriRequest.setHeader("content-type", contentType);
        }
        String responseString = "";
        HttpResponse httpResponse = this.coinbaseApacheHttpClient.execute(httpUriRequest);
        responseString = httpResponse.toString();
        logger.info("httpResponse.toString(): " + responseString);
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            InputStream instream = entity.getContent();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(instream));
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line);
                }
                if (200 == httpResponse.getStatusLine().getStatusCode()) {
                    responseString = stringBuilder.toString();
                }
                logger.log(Level.FINEST, responseString);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                httpUriRequest.abort();
                throw ex;
            }
            finally {
                instream.close();
            }
        }
        return responseString;
    }

    public void shutdown() {
        this.coinbaseApacheHttpClient.getConnectionManager().shutdown();
    }
}

