/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format.formatter;

import com.google.googlejavaformat.java.JavaFormatterOptions;
import org.mockito.Mockito;

public class GoogleJavaFormatterOptions {
    private final JavaFormatterOptions.Style style;
    private final boolean fixImportsOnly;
    private final boolean skipSortingImports;
    private final boolean skipRemovingUnusedImports;
    private int maxLineLength;

    public GoogleJavaFormatterOptions(boolean aosp, boolean fixImportsOnly, boolean skipSortingImports, boolean skipRemovingUnusedImports, int maxLineLength) {
        this.style = aosp ? JavaFormatterOptions.Style.AOSP : JavaFormatterOptions.Style.GOOGLE;
        this.fixImportsOnly = fixImportsOnly;
        this.skipSortingImports = skipSortingImports;
        this.skipRemovingUnusedImports = skipRemovingUnusedImports;
        this.maxLineLength = maxLineLength;
    }

    public JavaFormatterOptions javaFormatterOptions() {
        JavaFormatterOptions options = (JavaFormatterOptions)Mockito.spy((Object)JavaFormatterOptions.builder().style(this.style).build());
        ((JavaFormatterOptions)Mockito.doReturn((Object)this.maxLineLength).when((Object)options)).maxLineLength();
        return options;
    }

    public boolean isFixImportsOnly() {
        return this.fixImportsOnly;
    }

    public boolean isSkipSortingImports() {
        return this.skipSortingImports;
    }

    public boolean isSkipRemovingUnusedImports() {
        return this.skipRemovingUnusedImports;
    }

    public String toString() {
        return "GoogleJavaFormatterOptions{style=" + this.style + ", fixImportsOnly=" + this.fixImportsOnly + ", skipSortingImports=" + this.skipSortingImports + ", skipRemovingUnusedImports=" + this.skipRemovingUnusedImports + '}';
    }
}

