/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.liuanxin.api.model.DocumentUrl;
import com.github.liuanxin.api.util.Tools;
import java.util.ArrayList;
import java.util.List;

public class DocumentModule {
    @JsonIgnore
    private int index = Integer.MAX_VALUE;
    private String name;
    private String info = "";
    private List<DocumentUrl> urlList = new ArrayList<DocumentUrl>();

    public DocumentModule(String groupName) {
        if (Tools.isNotBlank(groupName)) {
            String[] split = groupName.split("-");
            if (split.length > 1) {
                this.name = split[0];
                this.info = split[1];
            } else {
                this.name = this.info = groupName;
            }
        }
    }

    public void addUrl(DocumentUrl url) {
        this.urlList.add(url);
    }

    public DocumentModule setIndex(int index) {
        this.index = index;
        return this;
    }

    public DocumentModule setName(String name) {
        this.name = name;
        return this;
    }

    public DocumentModule setInfo(String info) {
        this.info = info;
        return this;
    }

    public DocumentModule setUrlList(List<DocumentUrl> urlList) {
        this.urlList = urlList;
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getInfo() {
        return this.info;
    }

    public List<DocumentUrl> getUrlList() {
        return this.urlList;
    }

    public DocumentModule() {
    }
}

