/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.liuanxin.api.annotation.ParamType;
import com.github.liuanxin.api.model.DocumentParam;
import com.github.liuanxin.api.model.DocumentResponse;
import com.github.liuanxin.api.model.DocumentReturn;
import com.github.liuanxin.api.util.Tools;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class DocumentUrl {
    private static final String WRAP = "\n";
    private static final String WRAP_REPLACE = " <> ";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String COMMENT_START = "  /* ";
    private static final String COMMENT_END = " */";
    private static final String STR = String.class.getSimpleName();
    @JsonIgnore
    private int index = Integer.MAX_VALUE;
    private String title = "";
    private String desc = "";
    private String develop = "";
    private String exampleUrl;
    private String method;
    private String url;
    private List<DocumentParam> paramList;
    private List<DocumentResponse> responseList;
    private List<DocumentReturn> returnList;
    @JsonIgnore
    private boolean commentInReturnExample;
    @JsonIgnore
    private String returnJson;
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\/");
    private static final Pattern START_BIG_PATTERN = Pattern.compile("\\{");
    private static final Pattern END_BIG_PATTERN = Pattern.compile("\\}");

    public String getId() {
        String url = SPLIT_PATTERN.matcher(this.url).replaceAll("-");
        url = START_BIG_PATTERN.matcher(url).replaceAll("");
        url = END_BIG_PATTERN.matcher(url).replaceAll("");
        if (Tools.isNotBlank(this.method)) {
            return this.method.toLowerCase() + (url.startsWith("-") ? "" : "-") + url;
        }
        return url.startsWith("-") ? url.substring(1) : url;
    }

    public String getTitle() {
        return Tools.isBlank(this.title) ? this.getId() : this.title;
    }

    public String getCommentJson() {
        if (Tools.isBlank(this.returnJson)) {
            return "";
        }
        String commentJson = Tools.toPrettyJson(this.returnJson);
        if (Tools.isBlank(commentJson)) {
            return "";
        }
        if (!this.commentInReturnExample) {
            return commentJson;
        }
        StringBuilder sbd = new StringBuilder();
        String[] split = commentJson.split(WRAP);
        int index = 0;
        for (String comment : split) {
            DocumentReturn documentReturn;
            sbd.append(comment);
            String trim = comment.trim();
            if (this.returnList.size() > index && Tools.isNotBlank(documentReturn = this.returnList.get(index))) {
                String returnName = documentReturn.getName().replace("&nbsp;&nbsp;&nbsp;&nbsp;", "").trim();
                if (trim.startsWith(DOUBLE_QUOTE + returnName + DOUBLE_QUOTE)) {
                    String desc;
                    if (!STR.equalsIgnoreCase(documentReturn.getType()) && Tools.isNotBlank(desc = documentReturn.getDesc())) {
                        sbd.append(COMMENT_START).append(desc.replace(WRAP, WRAP_REPLACE)).append(COMMENT_END);
                    }
                    ++index;
                }
            }
            sbd.append(WRAP);
        }
        return sbd.delete(sbd.length() - 1, sbd.length()).toString();
    }

    public List<DocumentReturn> getReturnList() {
        if (this.commentInReturnExample) {
            return Collections.emptyList();
        }
        return this.returnList;
    }

    public boolean getHasExample() {
        if (Tools.isEmpty(this.paramList)) {
            return false;
        }
        for (DocumentParam param : this.paramList) {
            if (!Tools.isNotBlank(param) || !Tools.isNotBlank(param.getExample())) continue;
            return true;
        }
        return false;
    }

    public boolean getHasFile() {
        if (Tools.isEmpty(this.paramList)) {
            return false;
        }
        for (DocumentParam param : this.paramList) {
            if (!Tools.isNotBlank(param) || !param.getHasFile().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean getHasHeader() {
        if (Tools.isEmpty(this.paramList)) {
            return false;
        }
        for (DocumentParam param : this.paramList) {
            if (!Tools.isNotBlank(param) || !ParamType.hasHeader(param.getParamType())) continue;
            return true;
        }
        return false;
    }

    public DocumentUrl setIndex(int index) {
        this.index = index;
        return this;
    }

    public DocumentUrl setTitle(String title) {
        this.title = title;
        return this;
    }

    public DocumentUrl setDesc(String desc) {
        this.desc = desc;
        return this;
    }

    public DocumentUrl setDevelop(String develop) {
        this.develop = develop;
        return this;
    }

    public DocumentUrl setExampleUrl(String exampleUrl) {
        this.exampleUrl = exampleUrl;
        return this;
    }

    public DocumentUrl setMethod(String method) {
        this.method = method;
        return this;
    }

    public DocumentUrl setUrl(String url) {
        this.url = url;
        return this;
    }

    public DocumentUrl setParamList(List<DocumentParam> paramList) {
        this.paramList = paramList;
        return this;
    }

    public DocumentUrl setResponseList(List<DocumentResponse> responseList) {
        this.responseList = responseList;
        return this;
    }

    public DocumentUrl setReturnList(List<DocumentReturn> returnList) {
        this.returnList = returnList;
        return this;
    }

    public DocumentUrl setCommentInReturnExample(boolean commentInReturnExample) {
        this.commentInReturnExample = commentInReturnExample;
        return this;
    }

    public DocumentUrl setReturnJson(String returnJson) {
        this.returnJson = returnJson;
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getDevelop() {
        return this.develop;
    }

    public String getExampleUrl() {
        return this.exampleUrl;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public List<DocumentParam> getParamList() {
        return this.paramList;
    }

    public List<DocumentResponse> getResponseList() {
        return this.responseList;
    }

    public boolean isCommentInReturnExample() {
        return this.commentInReturnExample;
    }

    public String getReturnJson() {
        return this.returnJson;
    }
}

