/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.api.util;

import com.github.liuanxin.api.annotation.ApiParam;
import com.github.liuanxin.api.annotation.ApiParamIgnore;
import com.github.liuanxin.api.model.DocumentParam;
import com.github.liuanxin.api.util.Tools;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.MatrixVariable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.SessionAttribute;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.multipart.MultipartFile;

public final class ParamHandler {
    private static final LocalVariableTableParameterNameDiscoverer VARIABLE = new LocalVariableTableParameterNameDiscoverer();

    public static List<DocumentParam> handlerParam(HandlerMethod handlerMethod) {
        ArrayList<DocumentParam> params = new ArrayList<DocumentParam>();
        MethodParameter[] methodParameters = handlerMethod.getMethodParameters();
        for (int i = 0; i < methodParameters.length; ++i) {
            MethodParameter parameter = methodParameters[i];
            if (!Tools.isBlank(parameter.getParameterAnnotation(ApiParamIgnore.class))) continue;
            Class parameterType = parameter.getParameterType();
            if (!parameterType.equals(MultipartFile.class) && Tools.notBasicType(parameterType)) {
                for (Field field : parameterType.getDeclaredFields()) {
                    int mod = field.getModifiers();
                    if (Modifier.isStatic(mod) || Modifier.isFinal(mod) || !Tools.isBlank(field.getAnnotation(ApiParamIgnore.class))) continue;
                    ApiParam apiParam = field.getAnnotation(ApiParam.class);
                    params.add(ParamHandler.paramInfo(field.getName(), field.getType(), apiParam, false));
                }
                continue;
            }
            String paramName = VARIABLE.getParameterNames(parameter.getMethod())[i];
            ApiParam apiParam = (ApiParam)parameter.getParameterAnnotation(ApiParam.class);
            params.add(ParamHandler.paramInfo(paramName, parameterType, apiParam, ParamHandler.paramHasMust(parameter)));
        }
        return params;
    }

    private static boolean paramHasMust(MethodParameter parameter) {
        RequestParam requestParam = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        if (requestParam != null && requestParam.required()) {
            return true;
        }
        PathVariable pathVariable = (PathVariable)parameter.getParameterAnnotation(PathVariable.class);
        if (pathVariable != null && pathVariable.required()) {
            return true;
        }
        RequestBody requestBody = (RequestBody)parameter.getParameterAnnotation(RequestBody.class);
        if (requestBody != null && requestBody.required()) {
            return true;
        }
        RequestAttribute requestAttribute = (RequestAttribute)parameter.getParameterAnnotation(RequestAttribute.class);
        if (requestAttribute != null && requestAttribute.required()) {
            return true;
        }
        RequestHeader requestHeader = (RequestHeader)parameter.getParameterAnnotation(RequestHeader.class);
        if (requestHeader != null && requestHeader.required()) {
            return true;
        }
        RequestPart requestPart = (RequestPart)parameter.getParameterAnnotation(RequestPart.class);
        if (requestPart != null && requestPart.required()) {
            return true;
        }
        SessionAttribute sessionAttribute = (SessionAttribute)parameter.getParameterAnnotation(SessionAttribute.class);
        if (sessionAttribute != null && sessionAttribute.required()) {
            return true;
        }
        MatrixVariable matrixVariable = (MatrixVariable)parameter.getParameterAnnotation(MatrixVariable.class);
        if (matrixVariable != null && matrixVariable.required()) {
            return true;
        }
        CookieValue cookieValue = (CookieValue)parameter.getParameterAnnotation(CookieValue.class);
        return cookieValue != null && cookieValue.required();
    }

    private static DocumentParam paramInfo(String name, Class<?> type, ApiParam apiParam, boolean must) {
        String desc;
        DocumentParam param = new DocumentParam();
        param.setName(name);
        String inputType = Tools.getInputType(type);
        param.setDataType(inputType);
        param.setHasFile(Tools.hasFileInput(inputType));
        if (Tools.isNotBlank(apiParam)) {
            String dataType;
            String paramName;
            desc = apiParam.value();
            if (Tools.isNotBlank(desc)) {
                param.setDesc(desc);
            }
            if (Tools.isNotBlank(paramName = apiParam.name())) {
                param.setName(paramName);
            }
            if (Tools.isNotBlank(dataType = apiParam.dataType())) {
                param.setDataType(apiParam.dataType());
            }
            param.setParamType(apiParam.paramType().toString());
            String example = apiParam.example();
            if (Tools.isNotBlank(example)) {
                param.setExample(example);
            }
            param.setHasTextarea(apiParam.textarea());
        }
        param.setMust(must || Tools.isNotBlank(apiParam) && apiParam.must());
        if (type.isEnum()) {
            desc = param.getDesc();
            String enumInfo = Tools.enumInfo(type);
            param.setDesc(Tools.isBlank(desc) ? enumInfo : desc + "(" + enumInfo + ")");
        }
        return param;
    }
}

