/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.api.util;

import com.github.liuanxin.api.annotation.ApiReturn;
import com.github.liuanxin.api.annotation.ApiReturnIgnore;
import com.github.liuanxin.api.model.DocumentReturn;
import com.github.liuanxin.api.util.Tools;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReturnHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReturnHandler.class);
    public static final String TAB = "&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final String SPACE = " ";
    private static final Date TMP_DATE = new Date();
    private static final List<String> GENERIC_CLASS_NAME = Tools.lists("T", "E", "A", "K", "V");

    public static List<DocumentReturn> handlerReturn(String method, boolean recordLevel) {
        String type = method.substring(method.indexOf(SPACE)).trim();
        type = type.substring(0, type.indexOf(SPACE)).trim();
        ArrayList<DocumentReturn> returnList = new ArrayList<DocumentReturn>();
        ReturnHandler.handlerReturn("", "", recordLevel, type, returnList);
        return returnList;
    }

    private static void handlerReturn(String space, String parent, boolean recordLevel, String type, List<DocumentReturn> returnList) {
        String className;
        String string = className = type.contains("<") ? type.substring(0, type.indexOf("<")).trim() : type;
        if ("void".equals(className)) {
            return;
        }
        if (className.contains(SPACE)) {
            className = className.substring(className.indexOf(SPACE)).trim();
        }
        Class<?> outClass = null;
        try {
            outClass = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (Tools.isBlank(outClass)) {
            return;
        }
        if (outClass.isInterface()) {
            if (Collection.class.isAssignableFrom(outClass)) {
                if (type.contains("<") && type.contains(">")) {
                    String classType = type.substring(type.indexOf("<") + 1, type.lastIndexOf(">")).trim();
                    ReturnHandler.handlerReturn(space, parent, recordLevel, classType, returnList);
                }
            } else if (Map.class.isAssignableFrom(outClass)) {
                if (type.contains("<") && type.contains(">")) {
                    String keyAndValue = type.substring(type.indexOf("<") + 1, type.lastIndexOf(">")).trim();
                    String[] keyValue = keyAndValue.split(",");
                    if (keyValue.length == 2) {
                        ReturnHandler.handlerReturn(space, parent, recordLevel, keyValue[1].trim(), returnList);
                    } else if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("method ({}) map returnType({}) has problem", (Object)type, (Object)keyAndValue);
                    }
                }
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Unhandled interface class(just Collection or Map): {}", (Object)type);
            }
        } else if (Tools.notBasicType(outClass)) {
            HashMap<String, String> tmpFieldMap = Tools.newHashMap();
            for (Field field : outClass.getDeclaredFields()) {
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod) || !Tools.isBlank(field.getAnnotation(ApiReturnIgnore.class))) continue;
                String fieldName = field.getName();
                returnList.add(ReturnHandler.returnInfo(field, space + fieldName + parent));
                boolean notRecursive = ReturnHandler.notRecursiveGeneric(outClass, field);
                if (!notRecursive) continue;
                String genericType = field.getGenericType().toString();
                if (Tools.notBasicType(field.getType())) {
                    String innerParent = recordLevel ? " -> " + fieldName + parent : "";
                    ReturnHandler.handlerReturn(space + TAB, innerParent, recordLevel, genericType, returnList);
                }
                tmpFieldMap.put(genericType, fieldName);
            }
            if (type.contains("<") && type.contains(">")) {
                String innerType = type.substring(type.indexOf("<") + 1, type.lastIndexOf(">")).trim();
                String fieldName = ReturnHandler.handlerReturnFieldName(tmpFieldMap, innerType, recordLevel);
                String innerParent = recordLevel ? " -> " + fieldName + parent : "";
                ReturnHandler.handlerReturn(space + TAB, innerParent, recordLevel, innerType, returnList);
            }
        }
    }

    private static DocumentReturn returnInfo(Field field, String name) {
        Class<?> fieldType = field.getType();
        DocumentReturn documentReturn = new DocumentReturn();
        documentReturn.setName(name).setType(Tools.getInputType(fieldType));
        ApiReturn apiReturn = field.getAnnotation(ApiReturn.class);
        if (Tools.isNotBlank(apiReturn)) {
            documentReturn.setDesc(apiReturn.value());
            String returnType = apiReturn.type();
            if (Tools.isNotBlank(returnType)) {
                documentReturn.setType(returnType);
            }
        }
        if (fieldType.isEnum()) {
            String desc = documentReturn.getDesc();
            String enumInfo = Tools.enumInfo(fieldType);
            documentReturn.setDesc(Tools.isBlank(desc) ? enumInfo : desc + "(" + enumInfo + ")");
        }
        return documentReturn;
    }

    private static String handlerReturnFieldName(Map<String, String> fieldMap, String innerType, boolean recordLevel) {
        String name;
        if (!recordLevel) {
            return "";
        }
        for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
            String key = entry.getKey();
            for (String className : GENERIC_CLASS_NAME) {
                if (!key.equals(className)) continue;
                return entry.getValue();
            }
        }
        String innerOutType = innerType;
        if (innerType.contains("<")) {
            innerOutType = innerType.substring(0, innerType.indexOf("<")).trim();
        }
        if (Tools.isBlank(name = fieldMap.get(innerOutType))) {
            name = fieldMap.get(Object.class.getName());
        }
        return Tools.isBlank(name) ? "" : name;
    }

    public static String handlerReturnJson(String method) {
        String type = method.substring(method.indexOf(SPACE)).trim();
        Object obj = ReturnHandler.handlerReturnJsonObj(method, type = type.substring(0, type.indexOf(SPACE)).trim());
        return Tools.isNotBlank(obj) ? Tools.toJson(obj) : "";
    }

    private static Object handlerReturnJsonObj(String method, String type) {
        String className;
        String string = className = type.contains("<") ? type.substring(0, type.indexOf("<")).trim() : type;
        if ("void".equals(className)) {
            return null;
        }
        if (className.contains(SPACE)) {
            className = className.substring(className.indexOf(SPACE)).trim();
        }
        Class<?> outClass = null;
        try {
            outClass = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (Tools.isBlank(outClass)) {
            return null;
        }
        if (outClass.isInterface()) {
            if (Collection.class.isAssignableFrom(outClass)) {
                return ReturnHandler.handlerReturnJsonList(method, type, outClass);
            }
            if (Map.class.isAssignableFrom(outClass)) {
                return ReturnHandler.handlerReturnJsonMap(method, type);
            }
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Unhandled interface class(just Collection or Map): {}", (Object)type);
            }
        } else {
            Object obj = ReturnHandler.handlerReturnWithObjClazz(method, outClass);
            if (Tools.isNotBlank(obj) && type.contains("<") && type.contains(">")) {
                String innerType = type.substring(type.indexOf("<") + 1, type.lastIndexOf(">")).trim();
                ReturnHandler.handlerReturnJsonWithObj(method, outClass, innerType, obj);
            }
            return obj;
        }
        return null;
    }

    private static void handlerReturnJsonWithObj(String method, Class<?> outClass, String type, Object obj) {
        String className;
        String string = className = type.contains("<") ? type.substring(0, type.indexOf("<")).trim() : type;
        if ("void".equals(className)) {
            return;
        }
        if (className.contains(SPACE)) {
            className = className.substring(className.indexOf(SPACE)).trim();
        }
        Class<?> innerClass = null;
        try {
            innerClass = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (Tools.isBlank(innerClass)) {
            return;
        }
        if (innerClass.isInterface()) {
            if (Collection.class.isAssignableFrom(innerClass)) {
                ReturnHandler.setData(outClass, Collection.class, obj, ReturnHandler.handlerReturnJsonList(method, type, innerClass));
            } else if (Map.class.isAssignableFrom(innerClass)) {
                ReturnHandler.setData(outClass, Map.class, obj, ReturnHandler.handlerReturnJsonMap(method, type));
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Unhandled interface class(just Collection or Map): {}", (Object)type);
            }
        } else {
            Object value = ReturnHandler.handlerReturnWithObjClazz(method, innerClass);
            if (Tools.isNotBlank(value)) {
                ReturnHandler.setData(outClass, innerClass, obj, value);
                if (type.contains("<") && type.contains(">")) {
                    String innerType = type.substring(type.indexOf("<") + 1, type.lastIndexOf(">")).trim();
                    ReturnHandler.handlerReturnJsonWithObj(method, innerClass, innerType, value);
                }
            }
        }
    }

    private static void setData(Class<?> clazz, Class<?> fieldClazz, Object obj, Object value) {
        for (Field field : clazz.getDeclaredFields()) {
            Type clazzType;
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
            Type type = field.getGenericType();
            if (GENERIC_CLASS_NAME.contains(type.toString())) {
                ReturnHandler.setField(field, obj, value);
                continue;
            }
            if (!(type instanceof ParameterizedType) || !GENERIC_CLASS_NAME.contains((clazzType = ((ParameterizedType)type).getActualTypeArguments()[0]).toString()) && clazzType != fieldClazz) continue;
            Class<?> tmpClazz = ReturnHandler.getParameterizedType(type);
            Class<?> tmpType = ReturnHandler.getParameterizedType(clazzType);
            if (tmpClazz != null && Collection.class.isAssignableFrom(tmpClazz) || tmpType != null && Collection.class.isAssignableFrom(tmpType)) {
                ReturnHandler.setField(field, obj, Tools.lists(value));
                continue;
            }
            ReturnHandler.setField(field, obj, value);
        }
    }

    private static Class<?> getParameterizedType(Type type) {
        Class<?> tmpType = null;
        try {
            String className = type.toString();
            if (className.contains("<") && className.contains(">")) {
                className = className.substring(0, className.indexOf("<")).trim();
            }
            if (className.contains(SPACE)) {
                className = className.substring(className.indexOf(SPACE)).trim();
            }
            tmpType = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return tmpType;
    }

    private static Collection handlerReturnJsonList(String method, String type, Class clazz) {
        if (type.contains("<") && type.contains(">")) {
            AbstractCollection list;
            String obj = type.substring(type.indexOf("<") + 1, type.lastIndexOf(">")).trim();
            if (List.class.isAssignableFrom(clazz)) {
                list = new ArrayList();
            } else if (Set.class.isAssignableFrom(clazz)) {
                list = new HashSet();
            } else {
                return Collections.emptyList();
            }
            Object object = ReturnHandler.handlerReturnJsonObj(method, obj);
            if (Tools.isNotBlank(object)) {
                list.add(object);
            }
            return list;
        }
        return Collections.emptyList();
    }

    private static Map handlerReturnJsonMap(String method, String type) {
        if (type.contains("<") && type.contains(">")) {
            String keyAndValue = type.substring(type.indexOf("<") + 1, type.lastIndexOf(">"));
            String[] keyValue = keyAndValue.split(",");
            if (keyValue.length == 2) {
                HashMap<Object, Object> map = Tools.newHashMap();
                Object key = ReturnHandler.handlerReturnWithObj(method, keyValue[0].trim());
                Object value = ReturnHandler.handlerReturnJsonObj(method, keyValue[1].trim());
                if (key != null && Tools.isNotBlank(value)) {
                    map.put(key, value);
                }
                return map;
            }
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("method ({}) map returnType({}) has problem", (Object)type, (Object)keyAndValue);
            }
        }
        return Collections.emptyMap();
    }

    private static Object handlerReturnWithObj(String method, String className) {
        if (className.contains(SPACE)) {
            className = className.substring(className.indexOf(SPACE)).trim();
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (Tools.isBlank(clazz)) {
            return null;
        }
        return ReturnHandler.handlerReturnWithObjClazz(method, clazz);
    }

    private static Object handlerReturnWithObjClazz(String method, Class<?> clazz) {
        Object obj;
        if (Tools.isBlank(clazz) || clazz == Object.class) {
            return null;
        }
        if (Tools.basicType(clazz)) {
            return Tools.getReturnType(clazz);
        }
        if (clazz.isArray()) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("In the ({}) method, The entity({}) on return class is an array, unable to instantiate, please use List to replace. here will be ignored return", (Object)method, (Object)clazz.getName());
            }
            return null;
        }
        try {
            obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("In the ({}) method, The entity({}) on return class can't constructor, please ignore this url. here will be ignored return", (Object)method, (Object)clazz.getName());
            }
            return null;
        }
        for (Field field : clazz.getDeclaredFields()) {
            String[] value;
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod) || !Tools.isBlank(field.getAnnotation(ApiReturnIgnore.class))) continue;
            Class<?> type = field.getType();
            if (type == String.class) {
                ApiReturn apiReturn = field.getAnnotation(ApiReturn.class);
                value = "";
                if (Tools.isNotBlank(apiReturn)) {
                    value = apiReturn.value();
                }
                ReturnHandler.setField(field, obj, value);
                continue;
            }
            if (type == String[].class) {
                ApiReturn apiReturn = field.getAnnotation(ApiReturn.class);
                value = new String[]{""};
                if (Tools.isNotBlank(apiReturn)) {
                    value = new String[]{apiReturn.value()};
                }
                ReturnHandler.setField(field, obj, value);
                continue;
            }
            if (Tools.basicType(type)) {
                ReturnHandler.setField(field, obj, Tools.getReturnType(type));
                continue;
            }
            if (Date.class.isAssignableFrom(type)) {
                ReturnHandler.setField(field, obj, TMP_DATE);
                continue;
            }
            boolean notRecursive = ReturnHandler.notRecursiveGeneric(clazz, field);
            if (!notRecursive) continue;
            String genericInfo = field.getGenericType().toString();
            if (Collection.class.isAssignableFrom(type)) {
                ReturnHandler.setField(field, obj, ReturnHandler.handlerReturnJsonList(method, genericInfo, type));
                continue;
            }
            if (Map.class.isAssignableFrom(type)) {
                ReturnHandler.setField(field, obj, ReturnHandler.handlerReturnJsonMap(method, genericInfo));
                continue;
            }
            ReturnHandler.setField(field, obj, ReturnHandler.handlerReturnWithObj(method, genericInfo));
        }
        return obj;
    }

    private static void setField(Field field, Object obj, Object value) {
        block2: {
            try {
                field.setAccessible(true);
                field.set(obj, value);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn(String.format("Cannot assignment field %s to %s with %s", field, value, obj), (Throwable)e);
            }
        }
    }

    private static boolean notRecursiveGeneric(Class clazz, Field field) {
        try {
            Field signatureField = field.getClass().getDeclaredField("signature");
            signatureField.setAccessible(true);
            Object signature = signatureField.get(field);
            if (Tools.isBlank(signature)) {
                return true;
            }
            String fieldInfo = signature.toString();
            if (Tools.isBlank(fieldInfo)) {
                return true;
            }
            if (fieldInfo.contains("/") && fieldInfo.contains("<") && fieldInfo.contains(">")) {
                return !fieldInfo.replace("/", ".").contains(clazz.getName() + ";>;");
            }
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(String.format("class(%s), field(%s)", clazz, field.getName()), (Throwable)e);
            }
            return true;
        }
    }
}

