/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.api.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

public class Tools {
    private static final Logger LOGGER = LoggerFactory.getLogger(Tools.class);
    public static final String EMPTY = "";
    private static final String SPACE = " ";
    private static final String SPLIT = ",";
    private static final String FILE_TYPE = "file";
    private static final List<Class<?>> INT_TYPE = Tools.lists(Byte.TYPE, Byte.class, Character.TYPE, Character.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class);
    private static final List<Class<?>> DOUBLE_TYPE = Tools.lists(Float.TYPE, Float.class, Double.TYPE, Double.class, BigInteger.class, BigDecimal.class);
    private static final List<Class<?>> INT_ARRAY_TYPE = Tools.lists(byte[].class, Byte[].class, char[].class, Character[].class, short[].class, Short[].class, int[].class, Integer[].class, long[].class, Long[].class);
    private static final List<Class<?>> DOUBLE_ARRAY_TYPE = Tools.lists(float[].class, Float[].class, double[].class, Double[].class, BigInteger[].class, BigDecimal[].class);
    private static final List<Class<?>> BASIC_TYPE = Tools.lists(String.class, String[].class, Boolean.TYPE, Boolean.class, boolean[].class, Boolean[].class);
    private static final ObjectMapper RENDER;
    private static final ObjectWriter PRETTY_RENDER;

    public static boolean isBlank(Object obj) {
        return obj == null || EMPTY.equals(obj.toString().trim());
    }

    public static boolean isNotBlank(Object obj) {
        return !Tools.isBlank(obj);
    }

    public static String addPrefix(String src) {
        if (Tools.isBlank(src)) {
            return "/";
        }
        if (src.startsWith("/")) {
            return src;
        }
        return "/" + src;
    }

    public static String toJson(Object obj) {
        if (Tools.isBlank(obj)) {
            return EMPTY;
        }
        try {
            return RENDER.writeValueAsString(obj);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(String.format("obj(%s) to json exception", obj.toString()), (Throwable)e);
            }
            return EMPTY;
        }
    }

    public static String toPrettyJson(String json) {
        if (Tools.isBlank(json)) {
            return EMPTY;
        }
        try {
            return PRETTY_RENDER.writeValueAsString(RENDER.readValue(json, Object.class));
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(String.format("str(%s) to pretty json exception", json), (Throwable)e);
            }
            return EMPTY;
        }
    }

    private static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    private static <T> boolean isNotEmpty(T[] array) {
        return !Tools.isEmpty(array);
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> boolean isNotEmpty(Collection<T> collection) {
        return !Tools.isEmpty(collection);
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map map) {
        return !Tools.isEmpty(map);
    }

    public static <T> String toStr(Collection<T> collection) {
        if (Tools.isEmpty(collection)) {
            return EMPTY;
        }
        StringBuilder sbd = new StringBuilder();
        int i = 0;
        for (T t : collection) {
            sbd.append(t);
            if (i + 1 != collection.size()) {
                sbd.append(SPLIT);
            }
            ++i;
        }
        return sbd.toString();
    }

    static List lists(Object ... values) {
        return new ArrayList<Object>(Arrays.asList(values));
    }

    public static <T> Set<T> sets() {
        return new HashSet();
    }

    static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    private static Object getMethod(Object obj, String method, Object ... param) {
        if (Tools.isNotBlank(method)) {
            try {
                return obj.getClass().getDeclaredMethod(method, new Class[0]).invoke(obj, param);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                try {
                    return obj.getClass().getMethod(method, new Class[0]).invoke(obj, param);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    static String enumInfo(Class<?> clazz) {
        Enum[] constants;
        if (Tools.isNotBlank(clazz) && clazz.isEnum() && Tools.isNotEmpty(constants = (Enum[])clazz.getEnumConstants())) {
            StringBuilder sbd = new StringBuilder();
            String split = ", ";
            for (Enum em : constants) {
                Object code = Tools.getMethod(em, "getCode", new Object[0]);
                if (Tools.isNotBlank(code)) {
                    sbd.append(code).append(":");
                    Object value = Tools.getMethod(em, "getValue", new Object[0]);
                    sbd.append(Tools.isNotBlank(value) ? value : em.name());
                } else {
                    sbd.append(em.name());
                }
                sbd.append(split);
            }
            int len = split.length();
            if (sbd.length() > len) {
                return sbd.delete(sbd.length() - len, sbd.length()).toString();
            }
        }
        return EMPTY;
    }

    static boolean basicType(Class<?> clazz) {
        for (Class<?> typeClass : BASIC_TYPE) {
            if (clazz != typeClass) continue;
            return true;
        }
        return clazz.isEnum();
    }

    static boolean notBasicType(Class<?> clazz) {
        return !Tools.basicType(clazz);
    }

    public static boolean hasFileInput(String fileType) {
        return FILE_TYPE.equals(fileType);
    }

    static String getInputType(Class<?> type) {
        if (type == null) {
            return EMPTY;
        }
        if (MultipartFile.class.isAssignableFrom(type)) {
            return FILE_TYPE;
        }
        String paramType = type.getSimpleName();
        if (Tools.isBlank(paramType)) {
            return EMPTY;
        }
        if (type == String.class || type == String[].class) {
            return paramType.substring(0, 1).toLowerCase() + paramType.substring(1);
        }
        if (type.isEnum()) {
            return "Enum(" + paramType + ")";
        }
        for (Class<?> typeClass : INT_TYPE) {
            if (type != typeClass) continue;
            return Integer.TYPE.getSimpleName();
        }
        for (Class<?> typeClass : DOUBLE_TYPE) {
            if (type != typeClass) continue;
            return Double.TYPE.getSimpleName();
        }
        for (Class<?> typeClass : INT_ARRAY_TYPE) {
            if (type != typeClass) continue;
            return int[].class.getSimpleName();
        }
        for (Class<?> typeClass : DOUBLE_ARRAY_TYPE) {
            if (type != typeClass) continue;
            return double[].class.getSimpleName();
        }
        return paramType.substring(0, 1).toLowerCase() + paramType.substring(1);
    }

    static Object getReturnType(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return false;
        }
        if (clazz == boolean[].class || clazz == Boolean[].class) {
            return new boolean[]{false};
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return (byte)0;
        }
        if (clazz == byte[].class || clazz == Byte[].class) {
            return new byte[]{0};
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return Character.valueOf('\u0000');
        }
        if (clazz == char[].class || clazz == Character[].class) {
            return new char[]{'\u0000'};
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return (short)0;
        }
        if (clazz == short[].class || clazz == Short[].class) {
            return new short[]{0};
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return 0;
        }
        if (clazz == int[].class || clazz == Integer[].class) {
            return new int[]{0};
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return 0L;
        }
        if (clazz == long[].class || clazz == Long[].class) {
            return new long[]{0L};
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (clazz == float[].class || clazz == Float[].class) {
            return new float[]{0.0f};
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return 0.0;
        }
        if (clazz == double[].class || clazz == Double[].class) {
            return new double[]{0.0};
        }
        if (clazz == BigInteger.class) {
            return new BigInteger("0");
        }
        if (clazz == BigInteger[].class) {
            return new BigInteger[]{new BigInteger("0")};
        }
        if (clazz == BigDecimal.class) {
            return new BigDecimal(0.0);
        }
        if (clazz == BigDecimal[].class) {
            return new BigDecimal[]{new BigDecimal(0.0)};
        }
        if (clazz == String.class) {
            return EMPTY;
        }
        if (clazz == String[].class) {
            return new String[]{EMPTY};
        }
        if (clazz.isEnum()) {
            ?[] enumConstants = clazz.getEnumConstants();
            return enumConstants.length > 0 ? enumConstants[0] : null;
        }
        return null;
    }

    public static String getDomain() {
        boolean http;
        HttpServletRequest request = Tools.getRequestAttributes().getRequest();
        String scheme = request.getScheme();
        int port = request.getServerPort();
        if (port < 0) {
            port = 80;
        }
        StringBuilder sbd = new StringBuilder();
        sbd.append(scheme).append("://").append(request.getServerName());
        boolean bl = http = "http".equalsIgnoreCase(scheme) && port != 80;
        if (http || "https".equalsIgnoreCase(scheme) && port != 443) {
            sbd.append(':').append(port);
        }
        return sbd.toString();
    }

    private static ServletRequestAttributes getRequestAttributes() {
        return (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
    }

    static {
        BASIC_TYPE.addAll(INT_TYPE);
        BASIC_TYPE.addAll(DOUBLE_TYPE);
        BASIC_TYPE.addAll(INT_ARRAY_TYPE);
        BASIC_TYPE.addAll(DOUBLE_ARRAY_TYPE);
        RENDER = new ObjectMapper();
        PRETTY_RENDER = RENDER.writerWithDefaultPrettyPrinter();
    }
}

