/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.api.web;

import com.github.liuanxin.api.annotation.ApiGroup;
import com.github.liuanxin.api.annotation.ApiIgnore;
import com.github.liuanxin.api.annotation.ApiMethod;
import com.github.liuanxin.api.annotation.ApiResponse;
import com.github.liuanxin.api.annotation.ApiResponses;
import com.github.liuanxin.api.model.DocumentCopyright;
import com.github.liuanxin.api.model.DocumentInfo;
import com.github.liuanxin.api.model.DocumentModule;
import com.github.liuanxin.api.model.DocumentResponse;
import com.github.liuanxin.api.model.DocumentUrl;
import com.github.liuanxin.api.util.ParamHandler;
import com.github.liuanxin.api.util.ReturnHandler;
import com.github.liuanxin.api.util.Tools;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@ApiIgnore
@RestController(value="document-collect-controller")
@RequestMapping(value={"/api"})
public class DocumentController {
    static final String PARENT_URL_PREFIX = "/api";
    private static final String VERSION_URL = "/version";
    private static final String INFO_URL = "/info";
    private static final String EXAMPLE_URL = "/example/{id}.json";
    private static final String PRODUCES = "application/json; charset=UTF-8";
    private static final String CLASS_SUFFIX = "Controller";
    private static String document_str = null;
    private static DocumentInfo document_info = null;
    private static Map<String, DocumentUrl> url_map = null;
    private static final Lock LOCK = new ReentrantLock();
    @Autowired
    @Qualifier(value="requestMappingHandlerMapping")
    private RequestMappingHandlerMapping mapping;
    @Autowired
    private DocumentCopyright documentCopyright;
    private static final Pattern ID_URL_PATTERN = Pattern.compile("\\{.*?\\}");

    @GetMapping(value={"/version"}, produces={"application/json; charset=UTF-8"})
    public String urlVersion() {
        if (Tools.isBlank(this.documentCopyright) || this.documentCopyright.isOnline()) {
            return null;
        }
        if (Tools.isBlank(document_str)) {
            List<DocumentModule> moduleList;
            DocumentController.init(this.mapping, this.documentCopyright);
            if (Tools.isNotBlank(document_info) && Tools.isNotEmpty(moduleList = document_info.getModuleList())) {
                int apiCount = 0;
                for (DocumentModule module : moduleList) {
                    apiCount += module.getUrlList().size();
                }
                this.documentCopyright.setGroupCount(moduleList.size()).setApiCount(apiCount);
                document_info = null;
            }
        }
        return Tools.toJson(this.documentCopyright);
    }

    @GetMapping(value={"/info"}, produces={"application/json; charset=UTF-8"})
    public String url() {
        if (Tools.isBlank(this.documentCopyright) || this.documentCopyright.isOnline()) {
            return "";
        }
        if (Tools.isBlank(document_str)) {
            DocumentController.init(this.mapping, this.documentCopyright);
        }
        return document_str;
    }

    @GetMapping(value={"/example/{id}.json"}, produces={"application/json; charset=UTF-8"})
    public String urlExample(@PathVariable(value="id") String id) {
        if (Tools.isBlank(this.documentCopyright) || this.documentCopyright.isOnline()) {
            return "";
        }
        if (Tools.isEmpty(url_map)) {
            DocumentController.init(this.mapping, this.documentCopyright);
        }
        return url_map.get(id).getReturnJson();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(RequestMappingHandlerMapping mapping, DocumentCopyright copyright) {
        LOCK.lock();
        try {
            if (Tools.isNotEmpty(url_map) && Tools.isNotBlank(document_str)) {
                return;
            }
            HashMap<String, DocumentModule> moduleMap = Tools.newLinkedHashMap();
            HashMap<String, DocumentUrl> urlMap = Tools.newLinkedHashMap();
            Map handlerMethods = mapping.getHandlerMethods();
            for (Map.Entry entry : handlerMethods.entrySet()) {
                Set methodArray;
                Set urlArray;
                ApiIgnore ignore;
                RequestMappingInfo requestMapping = (RequestMappingInfo)entry.getKey();
                HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
                if (!Tools.isNotBlank(requestMapping) || !Tools.isNotBlank(handlerMethod) || !DocumentController.wasJsonApi(handlerMethod) || !Tools.isBlank(ignore = DocumentController.getAnnotation(handlerMethod, ApiIgnore.class)) && ignore.value() || DocumentController.ignoreUrl(urlArray = requestMapping.getPatternsCondition().getPatterns(), methodArray = requestMapping.getMethodsCondition().getMethods(), copyright.getIgnoreUrlSet())) continue;
                DocumentUrl url = new DocumentUrl();
                url.setUrl(Tools.toStr(urlArray));
                url.setMethod(Tools.toStr(methodArray));
                url.setParamList(ParamHandler.handlerParam(handlerMethod));
                url.setResponseList(DocumentController.handlerResponse(handlerMethod));
                String method = handlerMethod.toString();
                url.setReturnList(ReturnHandler.handlerReturn(method, copyright.isReturnRecordLevel()));
                url.setReturnJson(ReturnHandler.handlerReturnJson(method));
                ApiMethod apiMethod = DocumentController.getAnnotationByMethod(handlerMethod, ApiMethod.class);
                if (Tools.isNotBlank(apiMethod)) {
                    url.setTitle(apiMethod.title());
                    url.setDesc(apiMethod.desc());
                    url.setDevelop(apiMethod.develop());
                    url.setIndex(apiMethod.index());
                    url.setCommentInReturnExample(apiMethod.commentInReturnExample());
                } else {
                    url.setCommentInReturnExample(copyright.isCommentInReturnExample());
                }
                url.setExampleUrl(DocumentController.getExampleUrl(url.getId()));
                urlMap.put(url.getId(), url);
                ApiGroup apiGroup = DocumentController.getAnnotation(handlerMethod, ApiGroup.class);
                if (Tools.isBlank(apiGroup)) {
                    String className;
                    String info = className = handlerMethod.getBeanType().getSimpleName();
                    if (className.contains(CLASS_SUFFIX)) {
                        info = className.substring(0, className.indexOf(CLASS_SUFFIX));
                    }
                    DocumentController.addGroup(moduleMap, 0, info + "-" + className, url);
                    continue;
                }
                int index = apiGroup.index();
                for (String group : apiGroup.value()) {
                    if (!Tools.isNotBlank(group)) continue;
                    DocumentController.addGroup(moduleMap, index, group, url);
                }
            }
            url_map = urlMap;
            Collection modules = moduleMap.values();
            ArrayList<DocumentModule> moduleList = new ArrayList<DocumentModule>();
            if (Tools.isNotEmpty(modules)) {
                for (DocumentModule module : modules) {
                    Collections.sort(module.getUrlList(), new Comparator<DocumentUrl>(){

                        @Override
                        public int compare(DocumentUrl o1, DocumentUrl o2) {
                            return o1.getIndex() - o2.getIndex();
                        }
                    });
                    moduleList.add(module);
                }
                Collections.sort(moduleList, new Comparator<DocumentModule>(){

                    @Override
                    public int compare(DocumentModule o1, DocumentModule o2) {
                        return o1.getIndex() - o2.getIndex();
                    }
                });
            }
            DocumentInfo documentInfo = new DocumentInfo(copyright.getGlobalResponse(), moduleList);
            document_str = Tools.toJson(documentInfo);
            document_info = documentInfo;
        }
        finally {
            LOCK.unlock();
        }
    }

    private static List<DocumentResponse> handlerResponse(HandlerMethod handlerMethod) {
        ApiResponse[] responseArr;
        ArrayList<DocumentResponse> responseList = new ArrayList<DocumentResponse>();
        ApiResponses responses = DocumentController.getAnnotation(handlerMethod, ApiResponses.class);
        if (Tools.isNotBlank(responses) && (responseArr = responses.value()).length > 0) {
            for (ApiResponse response : responseArr) {
                responseList.add(new DocumentResponse(response.code(), response.msg()));
            }
        }
        return responseList;
    }

    private static String getExampleUrl(String param) {
        String domain = Tools.getDomain();
        if (domain.endsWith("/")) {
            domain = domain.substring(0, domain.length() - 1);
        }
        String exampleUrl = domain + Tools.addPrefix(PARENT_URL_PREFIX) + Tools.addPrefix(EXAMPLE_URL);
        return ID_URL_PATTERN.matcher(exampleUrl).replaceFirst(param);
    }

    private static void addGroup(Map<String, DocumentModule> moduleMap, int index, String group, DocumentUrl url) {
        DocumentModule module = moduleMap.get(group);
        if (Tools.isBlank(module)) {
            module = new DocumentModule(group);
            if (index > 0) {
                module.setIndex(index);
            }
        } else if (index != 0 && module.getIndex() > index) {
            module.setIndex(index);
        }
        module.addUrl(url);
        moduleMap.put(group, module);
    }

    private static boolean ignoreUrl(Set<String> urlSet, Set<RequestMethod> methodSet, Set<String> ignoreUrlSet) {
        if (Tools.isEmpty(ignoreUrlSet)) {
            ignoreUrlSet = Tools.sets();
        }
        ArrayList<String> methodList = new ArrayList<String>();
        for (RequestMethod method : methodSet) {
            methodList.add(method.name());
        }
        for (String ignoreUrl : ignoreUrlSet) {
            String tmpMethod;
            Object tmpUrl;
            String[] urlAndMethod;
            if (!ignoreUrl.startsWith("/")) {
                ignoreUrl = "/" + ignoreUrl;
            }
            if (ignoreUrl.contains("*")) {
                urlAndMethod = (ignoreUrl = ignoreUrl.replace("*", "(.*)?")).split("\\|");
                if (urlAndMethod.length == 2) {
                    tmpUrl = urlAndMethod[0];
                    tmpMethod = urlAndMethod[1].toUpperCase();
                    if (!methodList.contains(tmpMethod)) continue;
                    for (String url : urlSet) {
                        if (!url.matches((String)tmpUrl)) continue;
                        return true;
                    }
                    continue;
                }
                for (String url : urlSet) {
                    if (!url.matches(ignoreUrl)) continue;
                    return true;
                }
                continue;
            }
            urlAndMethod = ignoreUrl.split("\\|");
            if (urlAndMethod.length == 2) {
                tmpUrl = urlAndMethod[0];
                tmpMethod = urlAndMethod[1].toUpperCase();
                if (!urlSet.contains(tmpUrl) || !methodList.contains(tmpMethod)) continue;
                return true;
            }
            if (!urlSet.contains(ignoreUrl)) continue;
            return true;
        }
        return false;
    }

    private static boolean wasJsonApi(HandlerMethod handlerMethod) {
        ResponseBody annotation = DocumentController.getAnnotation(handlerMethod, ResponseBody.class);
        if (Tools.isNotBlank(annotation)) {
            return true;
        }
        RestController controller = DocumentController.getAnnotationByClass(handlerMethod, RestController.class);
        return Tools.isNotBlank(controller);
    }

    private static <T extends Annotation> T getAnnotationByMethod(HandlerMethod handlerMethod, Class<T> clazz) {
        return (T)handlerMethod.getMethodAnnotation(clazz);
    }

    private static <T extends Annotation> T getAnnotationByClass(HandlerMethod handlerMethod, Class<T> clazz) {
        return (T)AnnotationUtils.findAnnotation((Class)handlerMethod.getBeanType(), clazz);
    }

    private static <T extends Annotation> T getAnnotation(HandlerMethod handlerMethod, Class<T> clazz) {
        Annotation annotation = handlerMethod.getMethodAnnotation(clazz);
        if (Tools.isBlank(annotation)) {
            annotation = DocumentController.getAnnotationByClass(handlerMethod, clazz);
        }
        return (T)annotation;
    }
}

