/*
 * Decompiled with CFR 0.152.
 */
package ljbo82.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import ljbo82.util.Path;

public class EmbeddedResource {
    private final String path;
    private final URL url;

    public EmbeddedResource(String embeddedPath) throws Path.PathAccessException {
        embeddedPath = Path.fixPath(embeddedPath, Path.FileSeparator.FORWARD_SLASH);
        URL url = EmbeddedResource.class.getClassLoader().getResource(embeddedPath);
        if (url == null) {
            throw new Path.PathAccessException("Embedded path not found: %s", embeddedPath);
        }
        this.url = url;
        this.path = embeddedPath;
    }

    public String getPath() {
        return this.path;
    }

    public URL getUrl() {
        return this.url;
    }

    public InputStream getInputStream() {
        return this.getClass().getClassLoader().getResourceAsStream(this.path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMd5Checksum(int bufferSize) throws Path.PathAccessException {
        try (InputStream is = this.getInputStream();){
            String string = Path.getMd5Checksum(is, bufferSize);
            return string;
        }
        catch (IOException ex) {
            throw new Path.PathAccessException(ex);
        }
    }

    public final String getMd5Checksum() throws Path.PathAccessException {
        return this.getMd5Checksum(4096);
    }

    /*
     * Exception decompiling
     */
    public Path extract(Path destDir, String destinationFilename, int bufferSize, boolean forceOverwrite) throws Path.PathAccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final Path extract(Path destinationDir, String destFilename, boolean forceOverwrite) throws Path.PathAccessException {
        return this.extract(destinationDir, destFilename, 4096, forceOverwrite);
    }

    public final Path extract(Path destinationDir, boolean forceOverwrite) throws Path.PathAccessException {
        Path tmpFile = new Path(this.getPath());
        return this.extract(destinationDir, tmpFile.getName(), forceOverwrite);
    }

    public final Path extract(Path destinationDir) throws Path.PathAccessException {
        return this.extract(destinationDir, false);
    }
}

