/*
 * Decompiled with CFR 0.152.
 */
package ljbo82.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import ljbo82.util.Platform;
import ljbo82.util.StringUtils;
import ljbo82.util.UncheckedException;

public class Path
extends File {
    static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final Platform PLATFORM = Platform.getInstance();
    private static final StringUtils STRING_UTILS = StringUtils.getInstance();

    private static void throwIfNotSupported() {
        if (!PLATFORM.isSupported()) {
            throw new UnsupportedOperationException("Unsupported platform: " + PLATFORM.getName());
        }
    }

    static String fixPath(String path, FileSeparator fileSeparator) {
        path = path.trim();
        path = STRING_UTILS.replaceAll(path, "/\\", fileSeparator.getSlash(), true);
        path = STRING_UTILS.replaceAll(path, "\\/", fileSeparator.getSlash(), true);
        path = STRING_UTILS.replaceAll(path, "\\\\", fileSeparator.getSlash(), true);
        if ((path = STRING_UTILS.replaceAll(path, "//", fileSeparator.getSlash(), true)).length() > 1 && (path.endsWith("/") || path.endsWith("\\"))) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    static String fixPath(String path) {
        Path.throwIfNotSupported();
        FileSeparator nativeSep = FileSeparator.getNative();
        FileSeparator defaultSeparator = FileSeparator.FORWARD_SLASH;
        path = Path.fixPath(path, defaultSeparator);
        return STRING_UTILS.replaceAll(path, defaultSeparator.getSlash(), nativeSep.getSlash(), true);
    }

    static String getMd5Checksum(InputStream is, int bufferSize) throws IOException {
        try {
            int numRead;
            byte[] buffer = new byte[bufferSize];
            MessageDigest complete = MessageDigest.getInstance("MD5");
            while ((numRead = is.read(buffer)) > -1) {
                complete.update(buffer, 0, numRead);
            }
            return STRING_UTILS.getHexString(complete.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String getCannonicalPath(String path) {
        try {
            return new File(Path.getFilePath(path)).getCanonicalPath();
        }
        catch (IOException ex) {
            throw new PathAccessException(ex);
        }
    }

    private static String getFilePath(String path) {
        if ((path = Path.fixPath(path)).startsWith("~")) {
            path = Path.fixPath(String.format("%s/%s", PLATFORM.getUserHome(), path.substring(1)));
        }
        return new File(path).getAbsolutePath();
    }

    private static String getFilePath(String parentPath, String childPath) {
        File f;
        if ((childPath = Path.fixPath(childPath)).startsWith(FileSeparator.getNative().getSlash())) {
            f = new File(childPath);
        } else if (childPath.startsWith("~")) {
            f = new Path(childPath);
        } else {
            parentPath = Path.fixPath(parentPath);
            File parentFile = new File(parentPath);
            f = new File(parentFile, childPath);
        }
        return f.getAbsolutePath();
    }

    private static Path getOrCreateDirectory(File dir) throws PathAccessException {
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new PathAccessException("Cannot create/access '%s'", dir.getAbsolutePath());
            }
        } else if (dir.isFile()) {
            throw new IllegalArgumentException(String.format("Path '%s' is a file", dir.getAbsolutePath()));
        }
        if (PLATFORM.isWindows() && dir.getName().startsWith(".")) {
            try {
                Runtime.getRuntime().exec("attrib +H " + dir.getAbsolutePath()).waitFor();
            }
            catch (IOException | InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
        return new Path(dir);
    }

    public static Path getOrCreateDirectory(String dirPath) throws PathAccessException {
        return Path.getOrCreateDirectory(new Path(dirPath));
    }

    public static Path getOrCreateParentDir(String filePath) throws PathAccessException {
        Path path = new Path(filePath);
        Path parent = path.getParentFile();
        return Path.getOrCreateDirectory(parent.getAbsolutePath());
    }

    public Path(String path) {
        super(Path.getCannonicalPath(path));
    }

    public Path(String parentPath, String childPath) {
        this(Path.getCannonicalPath(Path.getFilePath(parentPath, childPath)));
    }

    public Path(Path parent, String childPath) {
        this(parent.getAbsolutePath(), childPath);
    }

    public Path(File coreFile) {
        this(Path.getCannonicalPath(coreFile.getAbsolutePath()));
    }

    public Path(File parent, String childPath) {
        this(Path.getCannonicalPath(Path.getFilePath(parent.getAbsolutePath(), childPath)));
    }

    public Path[] listFiles() {
        if (this.isFile()) {
            throw new PathAccessException("This path does not point to a directory: %s", this.getAbsolutePath());
        }
        File[] sFiles = super.listFiles();
        Path[] files = new Path[sFiles.length];
        for (int i = 0; i < sFiles.length; ++i) {
            files[i] = new Path(sFiles[i]);
        }
        return files;
    }

    public Path[] listFiles(FilenameFilter filter) {
        if (this.isFile()) {
            throw new PathAccessException("This path does not point to a directory: %s", this.getAbsolutePath());
        }
        File[] sFiles = super.listFiles(filter);
        Path[] files = new Path[sFiles.length];
        for (int i = 0; i < sFiles.length; ++i) {
            files[i] = new Path(sFiles[i]);
        }
        return files;
    }

    @Override
    public Path getParentFile() {
        return new Path(super.getParentFile());
    }

    @Override
    public Path getAbsoluteFile() {
        return new Path(super.getAbsoluteFile());
    }

    @Override
    public Path getCanonicalFile() throws IOException {
        return this;
    }

    public String getRelativeTo(Path other) {
        java.nio.file.Path from = this.toPath();
        java.nio.file.Path to = other.toPath();
        return from.relativize(to).toString();
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this);
    }

    public String getStringContents() throws IOException {
        try (InputStream is = this.getInputStream();){
            String string = STRING_UTILS.readInputStream(is);
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMd5Checksum(int bufferSize) throws PathAccessException {
        try (InputStream fis = this.getInputStream();){
            String string = Path.getMd5Checksum(fis, bufferSize);
            return string;
        }
        catch (IOException ex) {
            throw new PathAccessException(ex);
        }
    }

    public final String getMd5Checksum() throws PathAccessException {
        return this.getMd5Checksum(4096);
    }

    private void _delete() throws PathAccessException {
        if (!super.delete()) {
            throw new PathAccessException("Could not delete %s", this.getAbsolutePath());
        }
    }

    public void delete(boolean forceDirDelete) throws PathAccessException {
        if (!this.exists()) {
            throw new PathAccessException("Cannot delete %s (not found)", this.getAbsolutePath());
        }
        if (!this.getParentFile().canWrite()) {
            throw new PathAccessException("Cannot delete %s (permission denied)", this.getAbsolutePath());
        }
        if (this.isDirectory()) {
            for (Path f : this.listFiles()) {
                if (!forceDirDelete) {
                    throw new PathAccessException("Cannot delete non-empty directory: %s", this.getAbsolutePath());
                }
                f.delete(forceDirDelete);
            }
            this._delete();
        } else {
            this._delete();
        }
    }

    @Override
    public final boolean delete() throws PathAccessException {
        if (this.isDirectory()) {
            this.delete(false);
            return true;
        }
        if (!super.delete()) {
            throw new PathAccessException("Cannot delete %s", this.getAbsolutePath());
        }
        return true;
    }

    private void copy(Path baseDir, Path destinationDir, boolean replaceExisting) throws PathAccessException {
        if (!this.exists()) {
            throw new PathAccessException("%s does not exist", this.getAbsolutePath());
        }
        if (destinationDir.exists() && destinationDir.isFile()) {
            throw new PathAccessException("Destination is a file: %s", destinationDir.getAbsolutePath());
        }
        if (baseDir == null) {
            baseDir = this.isFile() ? new Path(this.getParentFile()) : this;
        }
        destinationDir = Path.getOrCreateDirectory(destinationDir);
        if (this.isFile()) {
            Path srcFile = this;
            Path destinationFile = new Path(destinationDir, srcFile.getName());
            if (destinationFile.exists()) {
                if (!replaceExisting) {
                    throw new PathAccessException("Destination already exists (%s)", destinationFile.getAbsolutePath());
                }
                destinationFile.delete();
            }
            try {
                Files.copy(srcFile.toPath(), destinationFile.toPath(), new CopyOption[0]);
            }
            catch (IOException ex) {
                throw new PathAccessException(ex);
            }
        } else {
            Path[] files;
            for (Path srcFile : files = this.listFiles()) {
                String relativePath = baseDir.getRelativeTo(srcFile.isDirectory() ? srcFile : srcFile.getParentFile());
                srcFile.copy(new Path(destinationDir, relativePath), replaceExisting);
            }
        }
    }

    public void copy(Path destinationDir, boolean replaceExisting) throws PathAccessException {
        this.copy(null, destinationDir, replaceExisting);
    }

    public static class PathAccessException
    extends UncheckedException {
        public PathAccessException() {
        }

        public PathAccessException(String msg, Object ... msgArgs) {
            super(msg, msgArgs);
        }

        public PathAccessException(Throwable cause, String msg, Object ... msgArgs) {
            super(cause, msg, msgArgs);
        }

        public PathAccessException(Throwable cause) {
            super(cause);
        }
    }

    static enum FileSeparator {
        BACKSLASH("\\"),
        FORWARD_SLASH("/");

        private final String slash;

        public static FileSeparator getNative() {
            String nativeSeparator;
            switch (nativeSeparator = System.getProperty("file.separator")) {
                case "\\": {
                    return BACKSLASH;
                }
                case "/": {
                    return FORWARD_SLASH;
                }
            }
            throw new UnsupportedOperationException("Unsupported native separator: " + nativeSeparator);
        }

        private FileSeparator(String slash) {
            this.slash = slash;
        }

        public String getSlash() {
            return this.slash;
        }
    }
}

