/*
 * Decompiled with CFR 0.152.
 */
package ljbo82.util;

import java.util.regex.Pattern;
import ljbo82.util.Path;

public class Platform {
    private static Platform singleton;
    private String name = null;
    private String arch = null;
    private String version = null;
    private Path tmpDir = null;
    private Path userHome = null;

    public static synchronized Platform getInstance() {
        if (singleton == null) {
            singleton = new Platform();
        }
        return singleton;
    }

    protected Platform() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Platform platform = this;
        synchronized (platform) {
            if (this.name == null) {
                this.name = System.getProperty("os.name");
            }
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getArch() {
        Platform platform = this;
        synchronized (platform) {
            if (this.arch == null) {
                this.arch = System.getProperty("os.arch");
            }
            return this.arch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        Platform platform = this;
        synchronized (platform) {
            if (this.version == null) {
                this.version = System.getProperty("os.version");
            }
            return this.version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getTemporaryDir() {
        Platform platform = this;
        synchronized (platform) {
            if (this.tmpDir == null) {
                this.tmpDir = new Path(System.getProperty("java.io.tmpdir"));
            }
            return this.tmpDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getUserHome() {
        Platform platform = this;
        synchronized (platform) {
            if (this.userHome == null) {
                this.userHome = new Path(System.getProperty("user.home"));
            }
            return this.userHome;
        }
    }

    public String getLibPrefix() {
        return "lib";
    }

    public String getLibSuffix() {
        if (this.isWindows()) {
            return ".dll";
        }
        if (this.isMac()) {
            return ".dylib";
        }
        if (this.isUnix() || this.isSolaris()) {
            return ".so";
        }
        throw new UnsupportedOperationException("Unsupported platform: " + this.getName());
    }

    public Path[] getLibrarySearchDirs() {
        String pathSeparator = System.getProperty("path.separator");
        String libraryPath = System.getProperty("java.library.path");
        String[] tokens = libraryPath.split(Pattern.quote(pathSeparator));
        Path[] paths = new Path[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            paths[i] = new Path(tokens[i]);
        }
        return paths;
    }

    boolean isSupported() {
        return this.isWindows() || this.isMac() || this.isSolaris() || this.isUnix();
    }

    public boolean isWindows() {
        return this.getName().toLowerCase().indexOf("win") >= 0;
    }

    public boolean isMac() {
        return this.getName().toLowerCase().indexOf("mac") >= 0;
    }

    public boolean isUnix() {
        String os = this.getName().toLowerCase();
        return os.toLowerCase().indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") > 0;
    }

    public boolean isSolaris() {
        return this.getName().toLowerCase().indexOf("sunos") >= 0;
    }
}

